/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexPointerBlock;
import hu.uw.pallergabor.dedexer.DexStringIdsBlock;
import java.io.IOException;

public class DexTypeIdsBlock
extends DexParser {
    private int[] types = null;
    private DexPointerBlock dexPointerBlock = null;
    private DexStringIdsBlock dexStringIdsBlock = null;

    @Override
    public void parse() throws IOException {
        int typesSize = (int)this.dexPointerBlock.getTypeIdsSize();
        this.file.seek(this.dexPointerBlock.getTypeIdsOffset());
        this.types = new int[typesSize];
        int i = 0;
        while (i < typesSize) {
            long typeIdx = this.read32Bit();
            this.types[i] = (int)typeIdx;
            String typeName = this.dexStringIdsBlock.getString(this.types[i]);
            this.dump("type[" + i + "] index: " + this.dumpLong(typeIdx) + " (" + typeName + ")");
            ++i;
        }
    }

    public int getTypesSize() {
        return (int)this.dexPointerBlock.getTypeIdsSize();
    }

    public String getType(int idx) {
        return this.dexStringIdsBlock.getString(this.types[idx]);
    }

    public String getClassName(int idx) {
        String className = this.dexStringIdsBlock.getString(this.types[idx]);
        className = DexTypeIdsBlock.LTypeToJava(className);
        return className;
    }

    public void setDexPointerBlock(DexPointerBlock dexPointerBlock) {
        this.dexPointerBlock = dexPointerBlock;
    }

    public void setDexStringIdsBlock(DexStringIdsBlock dexStringIdsBlock) {
        this.dexStringIdsBlock = dexStringIdsBlock;
    }

    public static String LTypeToJava(String LType) {
        String className = LType;
        if (className.startsWith("[")) {
            if (className.indexOf("[L") >= 0 && !className.endsWith(";")) {
                className = String.valueOf(className) + ";";
            }
        } else {
            if (className.startsWith("L")) {
                className = className.substring(1);
            }
            if (className.endsWith(";")) {
                className = className.substring(0, className.length() - 1);
            }
        }
        return className;
    }
}

