<?php

namespace backend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;
use yii\helpers\Html;
use yii\helpers\Json;
use common\components\AccessRule;
use common\models\User;
use yii\filters\AccessControl;
use common\components\FHtml;
use common\components\FApi;
use yii\db\Expression;
use backend\models\PushNotification; 
use backend\modules\app\models\AppUserDevice;

/**
 * FeedbackController implements the CRUD actions for AppUserFeedback model.
 */
class PushNotificationController extends BackendController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                    'bulk-delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'ruleConfig' => [
                    'class' => AccessRule::className(),
                ],
                'only' => ['create', 'update', 'delete', 'view', 'index'],
                'rules' => [
                    [
                        'actions' => ['view', 'index', 'create'],
                        'allow' => true,
                        'roles' => [
                            User::ROLE_USER,
                            User::ROLE_MODERATOR,
                            User::ROLE_ADMIN
                        ],
                    ],
                    [
                        'actions' => ['update'],
                        'allow' => true,
                        'roles' => [
                            User::ROLE_MODERATOR,
                            User::ROLE_ADMIN
                        ],
                    ],
                    [
                        'actions' => ['delete'],
                        'allow' => true,
                        'roles' => [
                            User::ROLE_ADMIN
                        ],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all AppUserFeedback models.
     * @return mixed
     */
    public function actionIndex()
    {    
        $model = new PushNotification();
     
        return $this->render('index', array(
            'model' => $model,
        ));
        
    }


    /**
     * Displays a single AppUserFeedback model.
     * @param integer $id
     * @return mixed
     */
    public function actionPush()
    {   

        $request = Yii::$app->request;
        $model = new PushNotification();

        if ($model->load($request->post()) && $model->save()) {

           $message = $model->message;
           $additional_data = $model->content;
           $type = '';

            $a_devices = array();
            $i_devices = array();

            $android_devices = AppUserDevice::find()->where('type = 1')->all();
            $ios_devices = AppUserDevice::find()->where('type = 2')->all();


            foreach ($android_devices as $a) {
                array_push($a_devices, $a->gcm_id);
            }
            foreach ($ios_devices as $i) {
                array_push($i_devices, $i->gcm_id);
            }

            if (count($a_devices) > 0) {

                try {
                    \Globals::pushAndroid($a_devices, $message, $type, $additional_data);

                } catch (\Exception $e) {
                   
                     return $e;
                }
            }

            // if (count($i_devices) > 0) {
            //     try {
            //         FApi::pushIos($i_devices, $message, $type, $additional_data);
            //     } catch (\Exception $e) {
            //          return $e;
            //     }
            // }


            $model = new PushNotification();
             return $this->render('index', array(
                'model' => $model,
            ));
        }
    
    }


   

   
}
