<?php

namespace backend\modules\api\controllers;

use backend\controllers\ApiController;

/**
 * Default controller for the `api` module
 */
class ListProductController extends ApiController
{
    /**
     * Renders the index view for the module
     * @return string
     */

    public function actions()
    {
        
        return [
            // get seller info and his product
            'listproduct' => [
                'class' => 'backend\modules\product\actions\ListProductSellerIdAction', 
                'checkAccess' => [$this, 'checkAccess']
            ],
            
            'list_product_radius' => [
                'class' => 'backend\modules\product\actions\ListProductRadiusAction', 
                'checkAccess' => [$this, 'checkAccess']
            ],

            'list_product_sub_cate' => [
                'class' => 'backend\modules\product\actions\ListProductSubCateAction', 
                'checkAccess' => [$this, 'checkAccess']
            ],

            'list_product_buyer_bought' => [
                'class' => 'backend\modules\product\actions\ListProductBuyerBoughtAction', 
                'checkAccess' => [$this, 'checkAccess']
            ],
            'list_product_seller_sold' => [
                'class' => 'backend\modules\product\actions\ListProductSellerSoldAction', 
                'checkAccess' => [$this, 'checkAccess']
            ],
        ];
    }

}
