<?php

namespace backend\modules\api\controllers;

use backend\controllers\ApiController;

/**
 * Default controller for the `api` module
 */
class MovieController extends ApiController
{
    /**
     * Renders the index view for the module
     * @return string
     */

    public function actions()
    {
        return [
            'info' => [
                'class' => 'backend\modules\movie\actions\MovieInfoAction',
                'checkAccess' => [$this, 'checkAccess']
            ],
            'all' => [
                'class' => 'backend\modules\movie\actions\MovieListAction',
                'checkAccess' => [$this, 'checkAccess']
            ],
            'genre' => [
                'class' => 'backend\modules\movie\actions\MovieGenreAction',
                'checkAccess' => [$this, 'checkAccess']
            ],
            'search' => [
                'class' => 'backend\modules\movie\actions\MovieSearchAction',
                'checkAccess' => [$this, 'checkAccess']
            ],
        ];
    }

}

