<?php
use yii\helpers\Html;
use kartik\form\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\file\FileInput;

/* @var $this yii\web\View */
/* @var $model backend\modules\app\models\AppUser */
/* @var $form yii\widgets\ActiveForm */
?>

<?php if (!Yii::$app->request->isAjax) {
$this->title = 'App User';
$this->params['breadcrumbs'][] = ['label' => $this->title, 'url' => 'index'];
$this->params['breadcrumbs'][] = ($model->isNewRecord)?'Create' : 'Update';
$this->params['mainIcon'] = 'fa fa-list';
$this->params['toolBarActions'] = array(
'linkButton'=>array(),
'button'=>array(),
'dropdown'=>array(),
);
} ?>
<?php if (Yii::$app->request->isAjax) { ?>

<?php $form = ActiveForm::begin(
        [
            'id' => 'app-user-form',
            'type' => $this->params['activeForm_type'],//ActiveForm::TYPE_HORIZONTAL,ActiveForm::TYPE_VERTICAL,ActiveForm::TYPE_INLINE
            'formConfig' => ['labelSpan' => 3, 'deviceSize' => ActiveForm::SIZE_MEDIUM, 'showErrors' => true],
            'staticOnly' => false, // check the Role here
            'readonly' => false, // check the Role here
            'options' => [
                //'class' => 'form-horizontal',
            ]
        ]); ?>

<input type="hidden" id="saveType" name="saveType">

    <?= $form->field($model, 'qb_id')->textInput() ?>

    <?= $form->field($model, 'avatar')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'username')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'password')->passwordInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'auth_key')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'password_hash')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'password_reset_token')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'description')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'content')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'gender')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'dob')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'phone')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'weight')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'height')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'address')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'country')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'state')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'city')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'balance')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'point')->textInput() ?>

    <?= $form->field($model, 'card_number')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'card_cvv')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'card_exp')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'lat')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'long')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'is_online')->textInput() ?>

    <?= $form->field($model, 'is_active')->textInput() ?>

    <?= $form->field($model, 'type')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'status')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'role')->textInput() ?>

    <?= $form->field($model, 'rate')->textInput() ?>

    <?= $form->field($model, 'rate_count')->textInput() ?>

    <?= $form->field($model, 'created_date')->textInput() ?>

    <?= $form->field($model, 'modified_date')->textInput() ?>

   <?php ActiveForm::end(); ?>


<?php } else { ?>

<div class="app-user-form">
    <div class="<?= $this->params['portletStyle'] ?>">
        <div class="portlet-title">
            <div class="caption font-dark">
                <span class="caption-subject bold uppercase">
                    <i class="<?php  echo $this->params['mainIcon'] ?>"></i>
                    <?= 'App User'?></span>
                <span class="caption-helper"><?=($model->isNewRecord) ? Yii::t('common', 'title.create') : Yii::t('common', 'title.update')?></span>
            </div>
            <div class="tools">
                <a href="#" class="collapse"></a>
                <a href="#" class="fullscreen"></a>
            </div>
            <div class="actions">
            </div>
        </div>
        <div class="portlet-body form">
            <?php $form = ActiveForm::begin([
            'id' => 'app-user-form',
            'type' => $this->params['activeForm_type'],//ActiveForm::TYPE_HORIZONTAL,ActiveForm::TYPE_VERTICAL,ActiveForm::TYPE_INLINE
            'formConfig' => ['labelSpan' => 3, 'deviceSize' => ActiveForm::SIZE_MEDIUM, 'showErrors' => true],
            'staticOnly' => false, // check the Role here
            'readonly' => false, // check the Role here
            'options' => [
                //'class' => 'form-horizontal',
                                'enctype' => 'multipart/form-data'
                            ]
            ]);
             ?>


            <div class="form">
                <div class="form-body">
                           <!--<?= $form->field($model, 'qb_id')->textInput() ?>-->

                                <?= $form->field($model, 'avatar_file')->widget(FileInput::classname(),
                                    ['options' => [
                                        'multiple' => false,
                                        'accept' => 'image/*'],
                                        'pluginOptions' => [
                                            'previewFileType' => 'image',
                                            'showRemove' => false,
                                            'showUpload' => false
                                        ]
                                    ]);?>

        <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>

        <?php 
            if($model->is_update == 1)
            { 
                // for update
                echo $form->field($model, 'email')->textInput(['maxlength' => true]);
                 echo $form->field($model, 'username')->textInput(['maxlength' => true, 'disabled' => true]);
            }
            else
            {
                // for create
                echo $form->field($model, 'email')->textInput(['maxlength' => true]);
                echo $form->field($model, 'username')->textInput(['maxlength' => true]);
            }
        ?>
       
      <?php 
      
            if(!isset($model->password))
            {
                $length = 10;

                $chars = array_merge(range(0,9), range('a','z'), range('A','Z'));

                shuffle($chars);

                $password = implode(array_slice($chars, 0, $length));
            }
            else
            {
                $password = $model->password;
            }   
        ?>

       <?= $form->field($model, 'password')->textInput(['maxlength' => true, 'value' => $password]) ?>
       
       <?= $form->field($model, 'is_active')->widget(SwitchInput::classname(), ['containerOptions' => ['class' => '']]) ?>

       <!--<?= $form->field($model, 'auth_key')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'password_hash')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'password_reset_token')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'description')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'content')->textarea(['rows' => 6]) ?>-->

       <!--<?= $form->field($model, 'gender')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'dob')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'phone')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'weight')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'height')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'address')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'country')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'state')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'city')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'balance')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'point')->textInput() ?>-->

       <!--<?= $form->field($model, 'card_number')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'card_cvv')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'card_exp')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'lat')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'long')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'is_online')->widget(SwitchInput::classname(), ['containerOptions' => ['class' => '']]) ?>-->

       <!--<?= $form->field($model, 'is_active')->widget(SwitchInput::classname(), ['containerOptions' => ['class' => '']]) ?>-->

       <!--<?= $form->field($model, 'type')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'status')->textInput(['maxlength' => true]) ?>-->

       <!--<?= $form->field($model, 'role')->textInput() ?>-->

       <!--<?= $form->field($model, 'rate')->textInput() ?>-->

       <!--<?= $form->field($model, 'rate_count')->textInput() ?>-->

                </div>
                <div class="form-actions">
                    <?= Html::submitButton($model->isNewRecord ? Yii::t('common', 'button.create')
                    : Yii::t('common', 'button.update'), ['class' => $model->isNewRecord ? 'btn btn-success' :
                    'btn btn-primary']) ?>
                    <?php  if (!$model->isNewRecord) {?>
                    <?=  Html::a(Yii::t('common', 'button.delete'), ['delete', 'id' => $model->id], [
                    'class' => 'btn btn-danger',
                    'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                    ],
                    ]); ?>
                    <?=  Html::a(Yii::t('common', 'button.cancel'), ['index'], ['class' => 'btn btn-default']) ?>
                    <?php } else { ?>
                    <?=  Html::a(Yii::t('common', 'button.cancel'), ['index'], ['class' => 'btn btn-default']) ?>
                    <?php } ?>                </div>
            </div>
               <?php ActiveForm::end(); ?>
        </div>

    </div>
</div>
<?php } ?>


