<?php

namespace backend\modules\genre;
use common\components\FHtml;
use Yii;

/**
 * Genre module definition class
 */
class Genre extends \yii\base\Module
{
    /**
     * @inheritdoc
     */
    public $controllerNamespace = 'backend\modules\genre\controllers';

    /**
     * @inheritdoc
     */
    public function init()
    {
        parent::init();

        // custom initialization code goes here
    }

    public static function createModuleMenu($module, $controller, $action){
        return
            array(
                array(
                    'active' => $module == 'genre' && ($controller == 'genre'),
                    'name' => Yii::t('common', 'Genre'),
                    'icon' => 'glyphicon glyphicon-play-circle',
                    'children' => array(
                        array(
                            'active' => $controller == 'genre',
                            'name' => Yii::t('common', 'Genre'),
                            'icon' => '',
                            'url' => Yii::$app->urlManager->createUrl(['/genre/genre/index']),
                        )
                    ),
                ),
            );
    }
}
