<?php

namespace backend\modules\genre\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\genre\models\Genre;

/**
 * GenreSearch represents the model behind the search form about `backend\modules\genre\models\Genre`.
 */
class GenreSearch extends Genre
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['genre'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Genre::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
        ]);

        $query->andFilterWhere(['like', 'genre', $this->genre]);

        return $dataProvider;
    }

    public static function searchAll()
    {
        return GenreAPI::find()->all();
    }
}
