<?php

namespace backend\modules\movie;
use common\components\FHtml;
use Yii;


/**
 * movie module definition class
 */
class Movie extends \yii\base\Module
{
    /**
     * @inheritdoc
     */
    public $controllerNamespace = 'backend\modules\movie\controllers';

    /**
     * @inheritdoc
     */
    public function init()
    {
        parent::init();

        // custom initialization code goes here
    }

    public static function getCategories($categories)
    {
        $category_names = array();
        /* @var ObjectRelation $category*/
        foreach ($categories as $category){
            $category_names[] = $category->category->name;
        }
        return implode(", ", $category_names);
    }

    public static function createModuleMenu($module, $controller, $action){
        return
            array(
                array(
                    'active' => $module == 'movie' && $controller == 'movie',
                    'name' => Yii::t('common', 'Movie'),
                    'icon' => 'glyphicon glyphicon-play-circle',
                    'children' => array(
                        array(
                            'active' => $controller == 'movie',
                            'name' => Yii::t('common', 'Movie'),
                            'icon' => '',
                            'url' => Yii::$app->urlManager->createUrl(['/movie/movie/index']),
                        ),
                        array(
                            'active' => $controller == 'people',
                            'name' => Yii::t('common', 'People'),
                            'icon' => '',
                            'url' => Yii::$app->urlManager->createUrl(['/people/people/index']),
                        ),
                        // array(
                        //     'active' => $controller == 'role',
                        //     'name' => Yii::t('common', 'Studio'),
                        //     'icon' => '',
                        //     'url' => Yii::$app->urlManager->createUrl(['/studio/studio/index']),
                        // ),
                        // array(
                        //     'active' => $controller == 'role',
                        //     'name' => Yii::t('common', 'Role'),
                        //     'icon' => '',
                        //     'url' => Yii::$app->urlManager->createUrl(['/role/role/index']),
                        // )
                    ),
                ),
            );
    }
}
