<?php

namespace backend\modules\movie\actions;

use backend\actions\BaseAction;
use backend\modules\movie\models\movie\MovieAPI;
use backend\modules\people\models\PeopleAPI;
use backend\modules\studio\models\StudioAPI;
use backend\modules\trailer\models\TrailerAPI;

use common\components\FHtml;
use common\components\Response;

use Yii;

class MovieListAction extends BaseAction
{
    public function run()
    {
        // if (($re = $this->isAuthorized())!== true)
        //     return $re;

        // $user_id = $this->user_id;

        $genre = isset($_REQUEST['genre']) ? $_REQUEST['genre'] : '';

        $page = FHtml::getRequestParam('page', 1);
        $number_per_page = FHtml::getRequestParam('number_per_page', 10);

        if(strlen($genre) == 0)
        {
            return Response::getOutputForAPI('', 'ERROR', 'MISSING_PARAMS', ['code'=> 202]);
        }

        $recordPerPage = $number_per_page;

        $total = MovieAPI::find()
        ->innerJoin('movie_genre','movie_genre.id_movie = movie.id')
        ->innerJoin('genre','genre.id = movie_genre.id_genre')
        ->where(['genre.id' => $genre])
        ->count();
            
        $total_page = ceil($total / $recordPerPage);
        $start_index = $page * $recordPerPage - $recordPerPage;

        $results = MovieAPI::find()
            ->innerJoin('movie_genre','movie_genre.id_movie = movie.id')
            ->innerJoin('genre','genre.id = movie_genre.id_genre')
            ->where(['genre.id' => $genre])
            ->limit($recordPerPage)
            ->offset($start_index)
            ->orderBy('id ASC')
            ->all(); 

            return Response::getOutputForAPI($results, 'SUCCESS', '', ['code' => 200], $total_page,$total*1);
    }
}