<?php

namespace backend\modules\movie\actions;

use backend\actions\BaseAction;
use backend\modules\movie\models\movie\MovieAPI;
use backend\modules\people\models\PeopleAPI;
use backend\modules\studio\models\StudioAPI;
use backend\modules\trailer\models\TrailerAPI;

use common\components\FHtml;
use common\components\Response;

use Yii;

class MovieSearchAction extends BaseAction
{
    public function run()
    {
        // if (($re = $this->isAuthorized())!== true)
        //     return $re;

        // $user_id = $this->user_id;

        $title = isset($_REQUEST['title']) ? $_REQUEST['title'] : '';

        $page = FHtml::getRequestParam('page', 1);
        $number_per_page = FHtml::getRequestParam('number_per_page', 10);

        if(strlen($title) == 0)
        {
            return Response::getOutputForAPI('', 'ERROR', 'MISSING_PARAMS', ['code'=> 202]);
        }

        $recordPerPage = $number_per_page;

        $total = MovieAPI::find()
        ->where(['LIKE','title', $title])
        ->count();
            
        $total_page = ceil($total / $recordPerPage);
        $start_index = $page * $recordPerPage - $recordPerPage;

        $results = MovieAPI::find()
            ->where(['LIKE','title', $title])
            ->limit($recordPerPage)
            ->offset($start_index)
            // ->orderBy('id ASC')
            ->all(); 

            return Response::getOutputForAPI($results, 'SUCCESS', '', ['code' => 200], $total_page,$total*1);
    }
}