<?php

namespace backend\modules\movie\controllers;

use Yii;
use backend\modules\movie\models\movie\Movie;
use backend\modules\movie\models\movie\MovieSearch;

use backend\modules\movie\models\moviegenre\MovieGenre;
use backend\modules\movie\models\moviestudio\MovieStudio;

use backend\modules\movie\models\moviepeople\MoviePeople;



use backend\modules\people\models\PeopleSearch;

use backend\modules\studio\models\StudioSearch;

//use yii\web\Controller;
use backend\controllers\BackendController;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\Response;
use yii\helpers\Html;
use yii\helpers\Json;
use common\components\AccessRule;
use common\models\User;
use yii\filters\AccessControl;
use common\components\FHtml;
use yii\web\UploadedFile;
use yii\imagine\Image;


/**
 * MovieController implements the CRUD actions for Movie model.
 */
class MovieController extends BackendController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                    'bulk-delete' => ['post'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'ruleConfig' => [
                    'class' => AccessRule::className(),
                ],
                'only' => ['create', 'update', 'delete', 'view', 'index'],
                'rules' => [
                    [
                        'actions' => ['view', 'index', 'create'],
                        'allow' => true,
                        'roles' => [
                            User::ROLE_USER,
                            User::ROLE_MODERATOR,
                            User::ROLE_ADMIN
                        ],
                    ],
                    [
                        'actions' => ['update'],
                        'allow' => true,
                        'roles' => [
                            User::ROLE_MODERATOR,
                            User::ROLE_ADMIN
                        ],
                    ],
                    [
                        'actions' => ['delete'],
                        'allow' => true,
                        'roles' => [
                            User::ROLE_ADMIN
                        ],
                    ],
                ],
            ],
        ];
    }

    /**
     * Lists all Movie models.
     * @return mixed
     */
    public function actionIndex()
    {    
        $searchModel = new MovieSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

           // validate if there is a editable input saved via AJAX
           if (Yii::$app->request->post('hasEditable')) {
               // instantiate your book model for saving
               $Id = Yii::$app->request->post('editableKey');

               $model = Movie::findOne($Id);

               // store a default json response as desired by editable
               $out = Json::encode(['output' => '', 'message' => '']);

               // fetch the first entry in posted data (there should
               // only be one entry anyway in this array for an
               // editable submission)
               // - $posted is the posted data for Book without any indexes
               // - $post is the converted array for single model validation
               $post = [];
               $posted = current($_POST['Movie']);
               $post['Movie'] = $posted;

               // load model like any single model validation
               if ($model->load($post)) {
                   // can save model or do something before saving model
                   $model->save();

                   // custom output to return to be displayed as the editable grid cell
                   // data. Normally this is empty - whereby whatever value is edited by
                   // in the input by user is updated automatically.
                   $output = '';
                   // similarly you can check if the name attribute was posted as well
                   // if (isset($posted['name'])) {
                   //   $output =  ''; // process as you need
                   // }
                   $out = Json::encode(['output' => $output, 'message' => '']);
               }
               // return ajax json encoded response and exit
               echo $out;
               return;
           }

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    public function passingData($array_need_to_pass, $factor, $symbol)
    {
        /**
         * $factor co the la 'genre', 'fullname'
         * $for co the la 'view', 'update
         */

        $result='';

        $index_of_the_last_el = count($array_need_to_pass);

        $i = 0;

        foreach($array_need_to_pass as $el)
        {
            if(++$i == $index_of_the_last_el)
            {
                $result.= $el["$factor"];
            }
            else
            {
                $result .= $el["$factor"].$symbol;
            }
            
        }
        
        return $result;
    }

    public function savingData($id,$var_name, $role)
    {
        if(strcmp($role, 'company') == 0)
        {
            if(is_array($var_name)){
                foreach ($var_name as $studio) {
                    $movieStudio = new MovieStudio();
                    $movieStudio->id_movie = $id;
                    $movieStudio->id_studio = $studio;
                    $movieStudio->save();
                }
            }
        }

        else if(strcmp($role, 'cast') == 0)
        {
            if(is_array($var_name)){
                foreach ($var_name as $people) {
                    $moviePeople = new MoviePeople();
                    $moviePeople->id_movie = $id;
                    $moviePeople->id_role = 2;
                    $moviePeople->id_people = $people;
                    $moviePeople->save();
                }
            }
        }

        else if(strcmp($role, 'director') == 0)
        {
            if(is_array($var_name)){
                foreach ($var_name as $people) {
                    $moviePeople = new MoviePeople();
                    $moviePeople->id_movie = $id;
                    $moviePeople->id_role = 1;
                    $moviePeople->id_people = $people;
                    $moviePeople->save();
                }
            }
        }

        else if(strcmp($role, 'genre') == 0)
        {
            if(is_array($var_name)){
                foreach ($var_name as $genre) {
                    $relation = new MovieGenre();
                    $relation->id_movie = $id;
                    $relation->id_genre = $genre;
                    $relation->save();
                }
            }
        }
        // cmt 24/8
        // if(strcmp($role,'company') == 0)
        // {
        //     if(strpos($var_name,'&') != false || strpos($var_name,'and') != false)
        //         {
        //                     //co 2 cong ty tro len
        //             $companies = preg_split( "/ (&|and) /", $var_name);

        //             foreach($companies as $eachName)
        //             {
        //                 $name = trim($eachName);
        //                 $idAfterCheck = StudioSearch::checkStudioByName($name);

        //                 $movieStudio = new MovieStudio();
        //                 $movieStudio->id_movie = $id;
        //                 $movieStudio->id_studio = $idAfterCheck;
        //                 $movieStudio->save();
        //             }
        //         }
                    
        //         else
        //         {
        //                     // co 1 cong ty
        //             $name = trim($var_name);
        //             $idAfterCheck = StudioSearch::checkStudioByName($name);

        //             $movieStudio = new MovieStudio();
        //             $movieStudio->id_movie = $id;
        //             $movieStudio->id_studio = $idAfterCheck;
        //             $movieStudio->save();
        //         }
        // }
        // else if(strcmp($role, 'genre') == 0)
        // {
        //     if(is_array($var_name)){
        //         foreach ($var_name as $genre) {
        //             $relation = new MovieGenre();
        //             $relation->id_movie = $id;
        //             $relation->id_genre = $genre;
        //             $relation->save();
        //         }
        //     }
        // }
        // else
        // {
        //     $position = (strcmp($role,'director') == 0) ? 1 : 2;

        //     if(strpos($var_name,'&') != false || strpos($var_name,'and') != false)
        //     {
        //         //co 2 nguoi tro len
        //         $fullName = preg_split( "/ (&|and) /", $var_name );

        //         foreach($fullName as $eachName)
        //         {
        //             $name = trim($eachName);
        //             if($name != '')
        //             {
        //                 $idAfterCheck = PeopleSearch::checkPeopleByFullName($name);

        //                 $moviePeople = new MoviePeople();
        //                 $moviePeople->id_movie = $id;
        //                 $moviePeople->id_role = $position;
        //                 $moviePeople->id_people = $idAfterCheck;
        //                 $moviePeople->save();
        //             }
                    
        //         }
        //     }
        //     else
        //     {
        //         // co 1 nguoi
        //         $name = trim($var_name);
        //         $idAfterCheck = PeopleSearch::checkPeopleByFullName($name);

        //         $moviePeople = new MoviePeople();
        //         $moviePeople->id_movie = $id;
        //         $moviePeople->id_role = $position;
        //         $moviePeople->id_people = $idAfterCheck;
        //         $moviePeople->save();
        //     }
        // }
        // end cmt 24/8
    }

    /**
     * Displays a single Movie model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {   
        $request = Yii::$app->request;

        $model = $this->findModel($id);

        /**
         * Code chinh
         */
        // passing genre to VIEW
        $arr_genre_results = Movie::findOne($model->id)->genres;

        $model->genre = $this->passingData($arr_genre_results, 'genre',', ');
        // $model->genre = gettype(Movie::getDb());

        // passing company to VIEW
        $arr_studio_results = Movie::findOne($model->id)->studio;

        $model->company = $this->passingData($arr_studio_results,'name',', ');

        // passing director to VIEW
        /**
         * movie join people join role (relation in people => have to define a realtion for it)
         */
        $arr_director_results = Movie::findOne($model->id)->getPeople()
            ->joinWith('role')
            ->where(['role.id' => '1'])
            ->all();

        $model->director = $this->passingData($arr_director_results, 'fullname',', ');

        // passing cast to VIEW
        $arr_cast_results = Movie::findOne($model->id)->getPeople()
            ->joinWith('role')
            ->where(['role.id' => '2'])
            ->all();

        $model->cast = $this->passingData($arr_cast_results, 'fullname',', ');
        

        /**
         * Het code chinh
         */

        if($request->isAjax){
            Yii::$app->response->format = Response::FORMAT_JSON;
            return [
                    'title'=> "Movie #".$id,
                    'content'=>$this->renderPartial('view', [
                        // 'model' => $this->findModel($id),
                        'model' => $model,
                    ]),
                    'footer'=>Html::a('Edit',['update','id'=>$id],['class'=>'btn btn-primary pull-left','role'=>$this->view->params['displayType']]).
                              Html::button('Close',['class'=>'btn btn-default','data-dismiss'=>"modal"])
                ];
        }else{
            return $this->render('view', [
                // 'model' => $this->findModel($id),
                'model' => $model
            ]);
        }
    }

    /**
     * Creates a new Movie model.
     * For ajax request will return json object
     * and for non-ajax request if creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $request = Yii::$app->request;
        $model = new Movie();  


        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if($request->isGet){
                return [
                    'title'=> "Create new Movie",
                    'content'=>$this->renderPartial('create', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
                ];         
            }else if($model->load($request->post()) && $model->save()){
                return [
                'forceReload'=>'#crud-datatable-pjax',
                'title'=> "Create new Movie",
                'content'=>'<span class="text-success">Create Movie success</span>',
                'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                Html::a('Create More',['create'],['class'=>'btn btn-primary','role'=>'modal-remote'])

                ];
            }else{
            return [
            'title'=> "Create new Movie",
            'content'=>$this->renderAjax('create', [
            'model' => $model,
            ]),
            'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
            Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])

            ];
            }
        }else{
            /*
            *   Process for non-ajax request
            */
            if ($model->load($request->post())) {
                    $time_string = time();
                    $image_file = UploadedFile::getInstance($model, 'image_file');
                    if ($image_file) {
                        $model->image = $time_string . rand(0, 1000) . '_movie_image.' . $image_file->extension;
                    }
                    if($model->save()) {

                        if ($image_file) {
                            $image_path = $this->uploadFolder . '/movie/' . $model->image;
                            $image_file->saveAs($image_path);
                        }

                        // start save genre in create
                        $genres = $_POST["Movie"]["genre"];

                        $this->savingData($model->id, $genres, 'genre');
                        // end save genre in create

                        // start save director in create
                        // $directorName = $_POST["Movie"]["director"];

                        // $this->savingData($model->id,$directorName,'director');
                        // end save director in create

                        // start save cast in create

                        // $castName = $_POST["Movie"]["cast"];

                        // $this->savingData($model->id,$castName,'cast');
                        // end save cast in create

                        // start save company in create
                        // $company = $_POST["Movie"]['company'];
                        
                        // $this->savingData($model->id, $company, 'company');
                        // end save company in create
                        
                                            
                    return $this->redirect(['index']);
                }else{
                    return $this->render('create', [
                        'model' => $model,
                    ]);
                }
            } else {
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        }
       
    }

    /**
     * Updates an existing Movie model.
     * For ajax request will return json object
     * and for non-ajax request if update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $request = Yii::$app->request;
        $model = $this->findModel($id);

        $image_old = $model->image;

        // code chinh
        
        // start passing genre to UPDATE
        $model->genre = MovieSearch::getAllGenreId($id);

        // start passing director to UPDATE
        // $model->director = MovieSearch::getAllDirector($id);

        // start passing cast to UPDATE
        // $model->cast = MovieSearch::getAllDirector($id);

        // start passing studio to UPDATE
        // $model->company = MovieSearch::getAllStudio($id);

        // ket thuc code chinh

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if($request->isGet){
                return [
                    'title'=> "Update Movie #".$id,
                    'content'=>$this->renderPartial('update', [
                        'model' => $this->findModel($id),
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
                ];         
            }else if($model->load($request->post()) && $model->save()){
                    return [
                        'forceReload'=>'#crud-datatable-pjax',
                        'title'=> "Movie #".$id,
                        'content'=>$this->renderAjax('view', [
                            'model' => $model,
                        ]),
                        'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                    Html::a('Edit',['update','id'=>$id],['class'=>'btn btn-primary','role'=>'modal-remote'])
                    ];
            }else{
                    return [
                        'title'=> "Update Movie #".$id,
                        'content'=>$this->renderAjax('update', [
                            'model' => $model,
                        ]),
                        'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                    Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
                    ];
            }
        }else{
            /*
            *   Process for non-ajax request
            */
            if ($model->load($request->post())) {

                    $time_string = time();
                    $image_file = UploadedFile::getInstance($model, 'image_file');
                    if ($image_file) {
                    if (isset($image_old)) {
                        if (is_file($this->uploadFolder . '/movie/' . $image_old)) {
                        unlink($this->uploadFolder . '/movie/' . $image_old);
                        }
                    }
                    $model->image = $time_string . rand(0, 1000) . '_movie_image.' . $image_file->extension;
                    }
                                        
                if($model->save()) {

                    if ($image_file) {
                        $image_path = $this->uploadFolder . '/movie/' . $model->image;
                        $image_file->saveAs($image_path);
                    }

                    // delete old data
                    // MoviePeople::deleteAll(['id_movie' => $id]);
                    MovieGenre::deleteAll(['id_movie' => $id]);
                    // MovieStudio::deleteAll(['id_movie' => $id]);
                    // end delete

                    // start save genre
                    $genres = $_POST["Movie"]["genre"];

                    $this->savingData($model->id, $genres, 'genre');
                    // end save genre

                    // start save director
                    // $directorName = $_POST["Movie"]["director"];

                    // $this->savingData($model->id,$directorName,'director');
                    // end save director

                    // start save cast
                    // $castName = $_POST["Movie"]["cast"];

                    // $this->savingData($model->id, $castName, 'cast');
                    // end save cast

                    // start save company in UPDATE
                    // $company = $_POST["Movie"]['company'];

                    // $this->savingData($model->id, $company, 'company');
                    // end save company in UPDATE
                    
                    return $this->redirect(['index']);
                }else{
                    return $this->render('create', [
                        'model' => $model,
                    ]);
                }
            } else {
                return $this->render('update', [
                    'model' => $model,
                ]);
            }
        }
    }

    /**
     * Delete an existing Movie model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $request = Yii::$app->request;
        $model = $this->findModel($id);
        
        if($model->delete())
        {
            MovieGenre::deleteAll(['id_movie' => $id]);
            // MoviePeople::deleteAll(['id_movie' => $id]);
        }
        

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(['index']);
        }


    }

     /**
     * Delete multiple existing Movie model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionBulkDelete()
    {
        $request = Yii::$app->request;
        $pks = explode(',', $request->post('pks')); // Array or selected records primary keys
        foreach ($pks as $pk) {
            $model = $this->findModel($pk);
            $model->delete();
        }

        if ($request->isAjax) {
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose' => true, 'forceReload' => '#crud-datatable-pjax'];
        } else {
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(['index']);
        }
    }

    public function actionBulkAction($action = '', $field = '', $value = '')
    {
        $request = Yii::$app->request;
        $pks = explode(',', $request->post('pks')); // Array or selected records primary keys
        foreach ($pks as $pk) {
            $model = $this->findModel($pk);
            if (isset($model)) {
                if ($action == FHtml::CHANGE_TYPE) {
                    $model[$field] = $value;
                    $model->save();
                }
                if($action == FHtml::CLEAR_TYPE){
                    $model[$field] = 0;
                    $model->save();
                }
                if($action == FHtml::FILL_TYPE){
                    $model[$field] = rand(0,99999);
                    $model->save();
                }
                //do something with other actions
            }
        }

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose' => true, 'forceReload' => '#crud-datatable-pjax'];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(['index']);
        }
    }


    /**
     * Finds the Movie model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Movie the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Movie::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
