<?php

namespace backend\modules\movie\models\movie;

use backend\modules\movie\models\moviegenre\MovieGenre;
use backend\modules\movie\models\moviepeople\MoviePeople;


class Movie extends MovieBase
{

        public $image_file;
        public $genre;
        public $company;
        public $director;
        public $cast;
        
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
        
            [['title', 'url', 'genre', 'source_id'], 'required'],
            // deleted from reqired 'release_year', 'rating', 'runtime','company','director',
            [['release_year', 'runtime','source_id','play_with'], 'integer'],
            [['rating'], 'number'],
            [['description'], 'string'],
            [['created_at'], 'safe'],
            [['image', 'title'], 'string', 'max' => 255],
            [['url'], 'string', 'max' => 2000],         
            [['image_file'], 'file','skipOnEmpty' => true, 'extensions'=>'jpg, gif, png'],    
            // [['url'], 'validation']                        
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'image' => 'Image',
            'title' => 'Title',
            'release_year' => 'Release Year',
            'rating' => 'IMDB Rating',
            'runtime' => 'Duration',
            'genre' => 'Genre',
            'director' => 'Director',
            'cast' => 'Cast',
            'company' => 'Comapny',
            'description' => 'Description',
            'url' => 'Url',
            'created_at' => 'Created At',
            'image_file' => 'Image File',
            'source_id' => 'Source Id',
            'play_with' => 'Play With',
            'actor' => 'Actor'
            ];
    }

    public function validation($attribute)
    {
        $part = parse_url($this->$attribute);
        if(isset($part['host']))
        {
            if(strcmp($part['host'], "www.youtube.com") != 0 && strcmp($part['host'], "youtu.be") != 0)
            {
                $this->addError($attribute, $part['host']);
            }
        }
        else
        {
            $this->addError($attribute, 'Wrong URL');
        }
    }
    
    public function getMovieGenre()
    {
        $this->hasMany(MovieGenre::className(), ['id_movie' => 'id']);
    }
    
    public function getMoviePerson()
    {
        $this->hasMany(MoviePeople::className(),['id_movie' => 'id']);
    }
}
