<?php
namespace backend\modules\movie\models\movie;

use Yii;

use backend\modules\movie\models\trailer\TrailerAPI;

use backend\modules\genre\models\GenreAPI;
use backend\modules\genre\models\Genre;
use backend\modules\people\models\PeopleAPI;
use backend\modules\role\models\RoleAPI;
use backend\modules\studio\models\StudioAPI;

/**
 * @property integer $id
 * @property string $image
 * @property string $title
 * @property integer $release_year
 * @property double $rating
 * @property integer $runtime
 * @property string $description
 * @property string $url
 * @property string $created_at
 */
class MovieBase extends \yii\db\ActiveRecord
{

    /**
    * @inheritdoc
    */
    public $tableName = 'movie';

    public static function tableName()
    {
        return 'movie';
    }

    // public function afterDelete()
    // {
    //     //$id = $this->id;
    //     $uploadFolder = Yii::getAlias('@'.UPLOAD_DIR);
    
    //             $image_old = $this->image;
    //     if(strlen($image_old)>0){
    //         if (is_file($uploadFolder . '/movie/' . $image_old)) {
    //             unlink($uploadFolder . '/movie/' . $image_old);
    //         }
    //     }
    //     parent::afterDelete(); // TODO: Change the autogenerated stub
    // }

    public function getTrailers()
    {
        return $this->hasMany(TrailerAPI::className(), ['id_movie' => 'id']);
    }

    public function getGenres()
    {
        return $this->hasMany(GenreAPI::className(), ['id' => 'id_genre'])
        ->viaTable('movie_genre', ['id_movie' => 'id']);
    }

    public function getStudio()
    {
        return $this->hasMany(StudioAPI::className(), ['id' => 'id_studio'])
        ->viaTable('movie_studio', ['id_movie' => 'id']);
    }

    public function getRole()
    {
        return $this->hasMany(RoleAPI::className(), ['id' => 'id_role'])
        ->viaTable('movie_people', ['id_movie' => 'id']);
    }

    public function getPeople()
    {
        return $this->hasMany(PeopleAPI::className(), ['id' => 'id_people'])
        ->viaTable('movie_people', ['id_movie' => 'id']);
    }
}
