<?php

namespace backend\modules\movie\models\movie;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\movie\models\movie\Movie;

/**
 * MovieSearch represents the model behind the search form about `backend\modules\movie\models\movie\Movie`.
 */
class MovieSearch extends Movie
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'release_year', 'runtime'], 'integer'],
            [['image', 'title', 'description', 'url', 'created_at'], 'safe'],
            [['rating'], 'number'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Movie::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'release_year' => $this->release_year,
            'rating' => $this->rating,
            'runtime' => $this->runtime,
            'created_at' => $this->created_at,
        ]);

        $query->andFilterWhere(['like', 'image', $this->image])
            ->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'description', $this->description])
            ->andFilterWhere(['like', 'url', $this->url]);

        return $dataProvider;
    }

    public static function getAllGenreId($id)
    {
        // for actionUpdate
        return Movie::find()
        ->select('genre.id')
        ->innerJoin('movie_genre', 'movie_genre.id_movie = movie.id')
        ->innerJoin('genre', 'genre.id = movie_genre.id_genre')
        ->where('movie.id = :id',[':id' => $id])
        ->all();
    }

    public static function getAllDirector($movie_id)
    {
        // for actionUpdate
        return Movie::find()
        ->select(['people.*'])
        ->innerJoin('movie_people', 'movie_people.id_movie = movie.id')
        ->innerJoin('role', 'role.id = movie_people.id_role')
        ->innerJoin('people', 'movie_people.id_people = people.id')
        ->where('role.id = :id_role',[':id_role' => '1'])
        ->andWhere('movie.id = :id',[':id' => $movie_id])
        ->all();
    }

    public static function getAllCast($movie_id)
    {
        // for actionUpdate
        return Movie::find()
        ->select(['people.*'])
        ->innerJoin('movie_people', 'movie_people.id_movie = movie.id')
        ->innerJoin('role', 'role.id = movie_people.id_role')
        ->innerJoin('people', 'movie_people.id_people = people.id')
        ->where('role.id = :id_role',[':id_role' => '2'])
        ->andWhere('movie.id = :id',[':id' => $movie_id])
        ->all();
    }

    public static function getAllStudio($movie_id)
    {
        // for actionUpdate
        return Movie::find()
        ->select(['studio.*'])
        ->innerJoin('movie_studio', 'movie_studio.id_movie = movie.id')
        ->innerJoin('studio', 'studio.id = movie_studio.id_studio')
        ->where('movie.id = :id',[':id' => $movie_id])
        ->all();
    }
}
