<?php

namespace backend\modules\movie\models\moviegenre;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\movie\models\moviegenre\MovieGenre;

/**
 * MovieGenreSearch represents the model behind the search form about `backend\modules\movie\models\moviegenre\MovieGenre`.
 */
class MovieGenreSearch extends MovieGenre
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'id_movie', 'id_genre'], 'integer'],
            [['created_at'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = MovieGenre::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'id_movie' => $this->id_movie,
            'id_genre' => $this->id_genre,
            'created_at' => $this->created_at,
        ]);

        return $dataProvider;
    }
}
