<?php

namespace backend\modules\movie\models\moviestudio;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\movie\models\moviestudio\MovieStudio;

/**
 * MovieStudioSearch represents the model behind the search form about `backend\modules\movie\models\moviestudio\MovieStudio`.
 */
class MovieStudioSearch extends MovieStudio
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'id_movie', 'id_studio'], 'integer'],
            [['created_at'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = MovieStudio::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'id_movie' => $this->id_movie,
            'id_studio' => $this->id_studio,
            'created_at' => $this->created_at,
        ]);

        return $dataProvider;
    }
}
