<?php

use yii\widgets\DetailView;
use yii\helpers\Html;
use common\components\FHtml;

/* @var $this yii\web\View */
/* @var $model backend\modules\movie\models\movie\Movie */
?>
<?php if (!Yii::$app->request->isAjax) {
$this->title = 'Movie';
$this->params['breadcrumbs'][] = ['label' => 'Movie', 'url' => 'index'];
$this->params['breadcrumbs'][] = Yii::t('common', 'title.view');
$this->params['toolBarActions'] = array(
'linkButton'=>array(),
'button'=>array(),
'dropdown'=>array(),
);
$this->params['mainIcon'] = 'fa fa-list';
} ?><?php if (Yii::$app->request->isAjax) { ?>
<div class="movie-view">

       <?= DetailView::widget([
    'model' => $model,
    'attributes' => [
                    'id',
                           [
                           'attribute' => 'image',
                           'value' => FHtml::showImageThumbnail($model->image, 300, 'movie'),
                           'format' => 'html',
                           ],
                'title',
                'genre',
                'company',
                'source_id',
                'director',
                'cast',
                'release_year',
                'rating',
                'runtime',
                'description:ntext',
                'url:url',
                'created_at',
    ],
    ]) ?>
</div>
<?php } else { ?>
<div class="<?= $this->params['portletStyle'] ?>">
    <div class="portlet-title">
        <div class="caption font-dark">
                <span class="caption-subject bold uppercase">
                <i class="<?php  echo $this->params['mainIcon'] ?>"></i>
                    <?= 'Movie'?>
</span>
            <span class="caption-helper"><?=  Yii::t('common', 'title.view') ?>
</span>
        </div>
        <div class="tools">
            <a href="#" class="collapse"></a>
            <a href="#" class="fullscreen"></a>
        </div>
        <div class="actions">
        </div>
    </div>
    <div class="portlet-body">
        <div class="row">
            <div class="col-md-12">
                <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                                           'id',
                           [
                           'attribute' => 'image',
                           'value' => FHtml::showImageThumbnail($model->image, 300, 'movie'),
                           'format' => 'html',
                           ],
                           'title',
                           'genre',
                           'company',
                           'director',
                           'cast',
                           'source_id',
                           'release_year',
                           'rating',
                           'runtime:datetime',
                           'description:ntext',
                           'url:url',
                           'created_at',
                ],
                ]) ?>
                <p>
                    <?=  Html::a( Yii::t('common', 'button.update'), ['update', 'id' => $model->id],
                    ['class' => 'btn btn-primary']) ?>
                    <?=  Html::a( Yii::t('common', 'button.delete'), ['delete', 'id' => $model->id], [
                    'class' => 'btn btn-danger',
                    'data' => [
                    'confirm' => 'Are you sure you want to delete this item ?',
                    'method' => 'post',
                    ],
                    ]) ?>
                    <?=  Html::a(Yii::t('common', 'button.cancel'), ['index'], ['class' => 'btn
                    btn-default']) ?>
                </p>
            </div>
        </div>
    </div>
</div>
<?php } ?>
