<?php
namespace backend\modules\people\models;

use backend\modules\role\models\RoleAPI;

use Yii;

/**
 * @property integer $id
 * @property string $fullname
 * @property string $created_at
 * @property string $modified_at
 */
class PeopleBase extends \yii\db\ActiveRecord
{

    /**
    * @inheritdoc
    */
    public $tableName = 'people';

    public static function tableName()
    {
        return 'people';
    }

    public function getRole()
    {
        return $this->hasMany(RoleAPI::className(), ['id' => 'id_role'])
            ->viaTable('movie_people', ['id_people' => 'id']);
    }
}
