<?php

namespace backend\modules\people\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\people\models\People;
use backend\modules\movie\models\movie\Movie;

/**
 * PeopleSearch represents the model behind the search form about `backend\modules\people\models\People`.
 */
class PeopleSearch extends People
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['fullname', 'created_at', 'modified_at'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = People::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'created_at' => $this->created_at,
            'modified_at' => $this->modified_at,
        ]);

        $query->andFilterWhere(['like', 'fullname', $this->fullname]);

        return $dataProvider;
    }

    public static function checkPeopleByFullName($fullName)
    {   
        // for actionCreate & actionUpdate
        $query = People::find()
        ->select(["fullname"])
        ->where("fullname = :fullname", [':fullname' => $fullName])
        ->exists();
        
        if($query)
        {
            // neu ton tai nguoi can tim trong db => lay id de ghi vao movie_person
            return People::find()
            ->select(["people.id"])
            ->where("fullname = :fullname", [':fullname' => $fullName])
            ->one()->id;
        }
        else
        {
            // neu khong ton tai => ghi vao db
            $people = new People();
            $people->fullname = $fullName;
            $people->save();

            return People::find()->max('id');
        }
    }

    public static function getAllDirector($id)
    {
        // for actionView
       
        // $query = People::find()
        // ->select('people.fullname')
        // ->innerJoin('movie_people', 'movie_people.id_people = people.id')
        // ->innerJoin('movie', 'movie.id = movie_people.id_movie = movie.id')
        // ->innerJoin('role', 'role.id = movie_people.id_role')
        // ->where('role.id = :id_role', [':id_role' => 1])
        // ->andWhere('movie.id = :id', [':id' => $id])
        // ->groupBy(['fullname'])
        // ->asArray()
        // ->all();

         // ham nay khong tra ve gi
        $query = Movie::find()
        ->select(['people.fullname'])
        ->from('movie')
        ->innerJoin('movie_people', 'movie_people.id_movie = movie.id')
        ->innerJoin('role','role.id = movie_people.id_role')
        ->innerJoin('people','people.id = movie_people.id_people')
        ->where('movie.id = :id', [':id' => $id])
        ->andWhere('role.id = :id_role', [':id_role' => 1])
        ->groupBy('people.fullname')
        ->asArray()
        ->all();

        return $query;
    }

    public static function getAllCast($id)
    {
        // for actionView
        $query = Movie::find()
        ->select(["people.fullname"])
        ->from('movie')
        ->innerJoin('movie_people', 'movie_people.id_movie = movie.id')
        ->innerJoin('role','role.id = movie_people.id_role')
        ->innerJoin('people','people.id = movie_people.id_people')
        ->where('movie.id = :id', [':id' => $id])
        ->andWhere('role.id = :id_role', [':id_role' => 2])
        ->groupBy(["fullname"])
        ->asArray()
        ->all();

        return $query;
    }
}
