<?php

namespace backend\modules\source;

use Yii;

/**
 * source module definition class
 */
class Source extends \yii\base\Module
{
    /**
     * @inheritdoc
     */
    public $controllerNamespace = 'backend\modules\source\controllers';

    /**
     * @inheritdoc
     */
    public function init()
    {
        parent::init();

        // custom initialization code goes here
    }

    public static function createModuleMenu($module, $controller, $action){
        return
            array(
                array(
                    'active' => $module == 'source' && $controller == 'source',
                    'name' => Yii::t('common', 'Source'),
                    'icon' => 'glyphicon glyphicon-play-circle',
                    'children' => array(
                        array(
                            'active' => $controller == 'source',
                            'name' => Yii::t('common', 'Source'),
                            'icon' => '',
                            'url' => Yii::$app->urlManager->createUrl(['/source/source/index']),
                        ),
                    ),
                ),
            );
    }
}
