<?php

namespace backend\modules\studio\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\studio\models\Studio;

/**
 * StudioSearch represents the model behind the search form about `backend\modules\studio\models\Studio`.
 */
class StudioSearch extends Studio
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['name', 'created_at', 'modified_at'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Studio::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'created_at' => $this->created_at,
            'modified_at' => $this->modified_at,
        ]);

        $query->andFilterWhere(['like', 'name', $this->name]);

        return $dataProvider;
    }

    public static function checkStudioByName($studioName)
    {
        $query = Studio::find()
        ->where('studio.name = :name', [':name' => $studioName])
        ->exists();

        if($query)
        {
            return Studio::find()->where('studio.name = :name', [':name' => $studioName])->one()->id;
        }
        else
        {
            $studio = new Studio();
            $studio->name = $studioName;
            $studio->save();

            return Studio::find()->max('id');
        }
    }

    public static function getAllStudio($id)
    {
        $query = (new \yii\db\Query())
        ->select('studio.name')
        ->from('studio')
        ->innerJoin('movie_studio', 'movie_studio.id_studio = studio.id')
        ->innerJoin('movie','movie.id = movie_studio.id_movie')
        ->where('movie.id = :id', [':id' => $id])
        ->groupBy('studio.name')
        ->all();

        return $query;
    }
}
