<?php
declare(strict_types=1);
session_start();
require_once __DIR__ . '/../config.php';

$err = ''; $ok = '';

// Handle Login Authentication
if (isset($_POST['u'], $_POST['p']) && !isset($_POST['action'])) {
    if (hash_equals(ADMIN_USER, (string)$_POST['u']) && hash_equals(ADMIN_PASS, (string)$_POST['p'])) {
        $_SESSION['neutro7_admin'] = true;
        header('Location: index.php'); 
        exit;
    }
    $err = 'Invalid login credentials';
}

$authed = !empty($_SESSION['neutro7_admin']);
$dns = read_dns_list();
if (!$dns) $dns = [''];

// Capture Status Messages from save.php redirects
if (!empty($_GET['ok'])) $ok = 'Settings updated successfully.';
if (!empty($_GET['e'])) $err = htmlspecialchars($_GET['e']);
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Neutro7 Admin | DNS Management</title>
    <script src="https://unpkg.com/lucide@latest"></script>
    <style>
        :root { 
            --bg: #0b101a; --card: #161b2c; --border: #2d3548; --text: #f0f2f5; 
            --muted: #94a3b8; --acc: #10b981; --danger: #ef4444; 
        }
        * { box-sizing: border-box; font-family: 'Inter', system-ui, -apple-system, sans-serif; font-size: 13px; }
        body { margin: 0; background: var(--bg); color: var(--text); display: flex; justify-content: center; min-height: 100vh; padding: 20px; }
        .container { width: 100%; max-width: 900px; }
        
        /* Header */
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px; }
        .brand { display: flex; align-items: center; gap: 8px; }
        .brand i { color: var(--acc); }
        .brand h1 { font-size: 15px; margin: 0; font-weight: 700; letter-spacing: -0.5px; }

        /* Grid Layout */
        .grid { display: grid; grid-template-columns: 1.3fr 0.7fr; gap: 15px; }
        @media (max-width: 768px) { .grid { grid-template-columns: 1fr; } }

        /* Cards */
        .card { background: var(--card); border: 1px solid var(--border); border-radius: 10px; padding: 16px; margin-bottom: 15px; }
        .card-title { font-size: 12px; font-weight: 700; margin-bottom: 15px; display: flex; align-items: center; gap: 6px; text-transform: uppercase; color: var(--muted); letter-spacing: 0.5px; }
        
        /* Form Elements */
        .dns-group { display: flex; gap: 8px; margin-bottom: 8px; align-items: center; }
        input { flex: 1; background: #0f172a; border: 1px solid var(--border); border-radius: 6px; padding: 8px 12px; color: #fff; outline: none; transition: border 0.2s; }
        input:focus { border-color: var(--acc); }
        label { display: block; font-size: 11px; color: var(--muted); margin-bottom: 4px; }
        
        /* Buttons */
        .btn { cursor: pointer; border: none; border-radius: 6px; padding: 8px 14px; font-weight: 600; display: inline-flex; align-items: center; gap: 6px; transition: 0.2s; text-decoration: none; }
        .btn-primary { background: var(--acc); color: #000; }
        .btn-primary:hover { opacity: 0.9; }
        .btn-outline { background: transparent; border: 1px solid var(--border); color: var(--text); }
        .btn-outline:hover { background: var(--border); }
        .btn-danger { color: var(--danger); background: rgba(239, 68, 68, 0.1); padding: 8px; }
        .btn-danger:hover { background: var(--danger); color: #fff; }

        /* Badges */
        .badge { font-size: 10px; min-width: 45px; text-align: center; background: rgba(255,255,255,0.05); color: var(--muted); padding: 3px 6px; border-radius: 4px; font-family: monospace; font-weight: 700; }
        .badge.active { background: rgba(16, 185, 129, 0.15); color: var(--acc); border: 1px solid rgba(16, 185, 129, 0.2); }

        /* Status Alerts */
        .status { padding: 10px; border-radius: 6px; margin-bottom: 15px; text-align: center; font-weight: 600; border: 1px solid transparent; }
        .status-ok { background: rgba(16, 185, 129, 0.1); color: var(--acc); border-color: var(--acc); }
        .status-err { background: rgba(239, 68, 68, 0.1); color: var(--danger); border-color: var(--danger); }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <div class="brand">
            <i data-lucide="globe"></i>
            <h1>NEUTRO7 DNS</h1>
        </div>
        <?php if ($authed): ?>
            <a href="logout.php" class="btn btn-outline" style="font-size:11px; padding: 5px 10px;">Logout</a>
        <?php endif; ?>
    </div>

    <?php if ($ok): ?><div class="status status-ok"><?=$ok?></div><?php endif; ?>
    <?php if ($err): ?><div class="status status-err"><?=$err?></div><?php endif; ?>

    <?php if (!$authed): ?>
        <div class="card" style="max-width: 320px; margin: 60px auto;">
            <div class="card-title">Admin Login</div>
            <form method="post">
                <label>Username</label>
                <input name="u" required autofocus style="margin-bottom:12px">
                <label>Password</label>
                <input type="password" name="p" required style="margin-bottom:18px">
                <button class="btn btn-primary" style="width:100%">Sign In</button>
            </form>
        </div>
    <?php else: ?>
        <div class="grid">
            <div class="card">
                <div class="card-title"><i data-lucide="list"></i> Upstream Portals</div>
                <form method="post" action="save.php">
                    <input type="hidden" name="action" value="update_dns">
                    <div id="dns-container">
                        <?php foreach ($dns as $index => $u): ?>
                        <div class="dns-group">
                            <span class="badge <?=($index === 0 ? 'active' : '')?>">#<?=($index + 1)?></span>
                            <input name="upstream[]" value="<?=htmlspecialchars($u)?>" placeholder="http://server-address:port">
                            <?php if($index > 0): ?>
                                <button type="button" class="btn btn-danger" onclick="removeField(this)"><i data-lucide="trash-2" size="14"></i></button>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <div style="margin-top:20px; display:flex; justify-content: space-between; align-items: center;">
                        <button type="button" class="btn btn-outline" onclick="addDnsField()"><i data-lucide="plus" size="14"></i> Add New</button>
                        <button class="btn btn-primary"><i data-lucide="save" size="14"></i> Save Portals</button>
                    </div>
                </form>
            </div>

            <div class="sidebar">
                <div class="card">
                    <div class="card-title"><i data-lucide="lock"></i> Access Security</div>
                    <form method="post" action="save.php">
                        <input type="hidden" name="action" value="update_auth">
                        <label>New Username</label>
                        <input name="new_user" placeholder="<?=htmlspecialchars(ADMIN_USER)?>" style="margin-bottom:10px">
                        <label>New Password</label>
                        <input type="password" name="new_pass" placeholder="••••••••" style="margin-bottom:15px">
                        <button class="btn btn-outline" style="width:100%; justify-content:center;">Update Admin</button>
                    </form>
                </div>

                <div class="card" style="background: rgba(0,0,0,0.15);">
                    <div class="card-title"><i data-lucide="info"></i> Info</div>
                    <div style="font-size:11px; color:var(--muted); line-height: 1.6;">
                        Current Active Portal:<br>
                        <span style="color:var(--text); word-break: break-all;"><?=htmlspecialchars($dns[0])?></span>
                        <hr style="border:0; border-top:1px solid var(--border); margin: 8px 0;">
                        System Path: <span style="color:var(--text)">/portal.txt</span>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
    lucide.createIcons();

    // Dynamically re-numbers the #1, #2 tags whenever the list changes
    function reindex() {
        const groups = document.querySelectorAll('.dns-group');
        groups.forEach((group, index) => {
            const badge = group.querySelector('.badge');
            badge.innerText = '#' + (index + 1);
            if(index === 0) {
                badge.classList.add('active');
            } else {
                badge.classList.remove('active');
            }
        });
    }

    function addDnsField() {
        const container = document.getElementById('dns-container');
        const div = document.createElement('div');
        div.className = 'dns-group';
        div.innerHTML = `
            <span class="badge">#</span>
            <input name="upstream[]" placeholder="http://...">
            <button type="button" class="btn btn-danger" onclick="removeField(this)"><i data-lucide="trash-2" size="14"></i></button>
        `;
        container.appendChild(div);
        lucide.createIcons();
        reindex();
    }

    function removeField(btn) {
        btn.parentElement.remove();
        reindex();
    }
</script>
</body>
</html>