<?php
session_start();
require_once __DIR__ . '/../config.php';
if (empty($_SESSION['neutro7_admin'])) { header('Location: index.php'); exit; }

$action = $_POST['action'] ?? '';

// 1. Handle DNS Updates
if ($action === 'update_dns') {
    $list = $_POST['upstream'] ?? [];
    $clean = [];
    foreach ($list as $u) {
        $u = trim($u);
        if ($u !== '') $clean[] = $u;
    }
    if (!$clean) { header('Location: index.php?e=DNS list cannot be empty'); exit; }

    file_put_contents(DNS_FILE, json_encode(['dns'=>$clean], JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
    file_put_contents(PORTAL_FILE, $clean[0]);
    header('Location: index.php?ok=1');
    exit;
}

// 2. Handle Credential Updates
if ($action === 'update_auth') {
    $new_user = trim($_POST['new_user'] ?? '');
    $new_pass = trim($_POST['new_pass'] ?? '');
    
    if ($new_user === '' && $new_pass === '') {
        header('Location: index.php?e=No changes provided');
        exit;
    }

    // Load current config content
    $configPath = __DIR__ . '/../config.php';
    $configContent = file_get_contents($configPath);

    // Replace Username if provided
    if ($new_user !== '') {
        $configContent = preg_replace("/define\('ADMIN_USER',\s*'.*?'\);/", "define('ADMIN_USER', '$new_user');", $configContent);
    }

    // Replace Password if provided
    if ($new_pass !== '') {
        $configContent = preg_replace("/define\('ADMIN_PASS',\s*'.*?'\);/", "define('ADMIN_PASS', '$new_pass');", $configContent);
    }

    if (file_put_contents($configPath, $configContent)) {
        header('Location: index.php?ok=Credentials updated');
    } else {
        header('Location: index.php?e=Failed to write to config.php');
    }
    exit;
}