<?php
error_reporting(0);
require_once __DIR__ . '/config.php';

header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

function cache_path(): string { return __DIR__ . '/dns_cache.json'; }
function read_cache(): array {
    $p = cache_path();
    if (!file_exists($p)) return [];
    $j = json_decode(@file_get_contents($p), true);
    return is_array($j) ? $j : [];
}
function write_cache(array $c): void {
    $p = cache_path();
    $t = $p . '.tmp';
    @file_put_contents($t, json_encode($c, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES), LOCK_EX);
    @rename($t, $p);
}

function http_get(string $url, int $timeout = 6): array {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_CONNECTTIMEOUT => $timeout,
        CURLOPT_TIMEOUT => $timeout,
        CURLOPT_USERAGENT => 'Neutro7-MultiDNS/1.0'
    ]);
    $body = curl_exec($ch);
    $err  = curl_error($ch);
    $code = (int)curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
    curl_close($ch);
    return [$code, $body === false ? '' : $body, $err];
}

function auth_ok(string $json): bool {
    $d = json_decode($json, true);
    if (!is_array($d)) return false;
    if (isset($d['user_info']['auth'])) return (string)$d['user_info']['auth'] === '1' || $d['user_info']['auth'] === 1;
    if (isset($d['auth'])) return (string)$d['auth'] === '1' || $d['auth'] === 1;
    if (isset($d['user_info']['status'])) return true;
    return false;
}

function check_dns_login(string $dns, string $u, string $p): bool {
    $dns = rtrim(trim($dns), '/');
    if ($dns === '') return false;
    $url = $dns . '/player_api.php?username=' . rawurlencode($u) . '&password=' . rawurlencode($p);
    [$code, $body, ] = http_get($url, 6);
    if ($code < 200 || $code >= 300) return false;
    return auth_ok($body);
}

function resolve_dns(string $u, string $p, array $dns_list): ?string {
    $cache = read_cache();
    $cached = $cache[$u]['dns'] ?? '';
    if (is_string($cached) && $cached !== '' && check_dns_login($cached, $u, $p)) {
        return $cached;
    }
    foreach ($dns_list as $dns) {
        if (!is_string($dns)) continue;
        $dns = trim($dns);
        if ($dns === '' || $dns === $cached) continue;
        if (check_dns_login($dns, $u, $p)) {
            $cache[$u] = ['dns' => $dns, 'ts' => time()];
            write_cache($cache);
            return $dns;
        }
    }
    if (isset($cache[$u])) { unset($cache[$u]); write_cache($cache); }
    return null;
}

$path = isset($_GET['path']) ? (string)$_GET['path'] : '';
if ($path === '') { http_response_code(400); echo 'missing path'; exit; }

// Try to obtain credentials from query OR from the path (Xtream pattern).
$u = isset($_GET['username']) ? (string)$_GET['username'] : '';
$p = isset($_GET['password']) ? (string)$_GET['password'] : '';

if ($u === '' || $p === '') {
    $parts = explode('/', trim($path, '/'));
    // Expected: live/user/pass/...
    if (count($parts) >= 3) {
        $u = $parts[1] ?? '';
        $p = $parts[2] ?? '';
    }
}

if ($u === '' || $p === '') { http_response_code(400); echo 'missing credentials'; exit; }

$dns = resolve_dns($u, $p, read_dns_list());
if ($dns === null) { http_response_code(503); echo 'all dns failed'; exit; }

$target = rtrim($dns, '/') . '/' . ltrim($path, '/');
header('Location: ' . $target, true, 302);
exit;
