<?php
header('Content-Type: application/json; charset=UTF-8');

$db = new SQLite3(__DIR__ . "/maxrebrandscode_qrcode.db");

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$baseUrl = $protocol . $_SERVER['HTTP_HOST'] . dirname($_SERVER['SCRIPT_NAME']) . "/qr/";

$res = $db->query("SELECT image FROM qrcode WHERE id = 1");
$row = $res->fetchArray(SQLITE3_ASSOC);

$data = [];

if (!empty($row['image'])) {
    $data[] = [
        "AdName" => "QR Code",
        "AdUrl"  => $baseUrl . $row['image']
    ];
}

echo json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
