<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

include 'session_check.php';

$page_title = "Gerenciar QR Code";

/* ===============================
   CONEXÃO COM BANCO
================================ */
$db = new SQLite3("./api/maxrebrandscode_qrcode.db");

/* ===============================
   TABELA (já existe)
   id | qrcode | image
================================ */
$db->exec("CREATE TABLE IF NOT EXISTS qrcode (
    id INTEGER PRIMARY KEY,
    qrcode TEXT
)");

/* ===============================
   ADICIONA COLUNA image (se não existir)
================================ */
@$db->exec("ALTER TABLE qrcode ADD COLUMN image TEXT");

/* ===============================
   GARANTE REGISTRO ID = 1
================================ */
$res = $db->query("SELECT COUNT(*) as total FROM qrcode");
$row = $res->fetchArray(SQLITE3_ASSOC);

if ($row['total'] == 0) {
    $db->exec("INSERT INTO qrcode (id, qrcode, image) VALUES (1, '', '')");
}

/* ===============================
   ATUALIZA QR CODE
================================ */
if (isset($_POST["submit"])) {

    $newQrcode = trim($_POST["qrcode"]);

    // Pasta do QR
    $qrDir = __DIR__ . "/api/qr/";
    if (!is_dir($qrDir)) {
        mkdir($qrDir, 0755, true);
    }

    // Nome do arquivo
    $fileName = "qrcode.png";
    $filePath = $qrDir . $fileName;

    // Gera QR Code
    $qrImageUrl = "https://image-charts.com/chart?chs=500x500&cht=qr&chl=" . urlencode($newQrcode);
    $imageData = file_get_contents($qrImageUrl);

    if ($imageData !== false) {
        file_put_contents($filePath, $imageData);

        // Atualiza banco
        $stmt = $db->prepare("UPDATE qrcode SET qrcode = :qrcode, image = :image WHERE id = 1");
        $stmt->bindValue(':qrcode', $newQrcode, SQLITE3_TEXT);
        $stmt->bindValue(':image', $fileName, SQLITE3_TEXT);
        $stmt->execute();
    }

    $db->close();
    header("Location: qrcode.php?r=atualizado");
    exit;
}

/* ===============================
   BUSCA DADOS ATUAIS
================================ */
$res = $db->query("SELECT qrcode, image FROM qrcode WHERE id = 1");
$row = $res->fetchArray(SQLITE3_ASSOC);

$qrcode = $row['qrcode'] ?? '';
$image  = $row['image'] ?? '';

/* ===============================
   CONTEÚDO DA PÁGINA
================================ */
$page_content = '
<div class="container-fluid">
    <div class="card radius-10">
        <div class="card-body">
            <center>
                <h4 class="card-title">QR Code Atual:</h4>';

if (!empty($image) && file_exists(__DIR__ . "/api/qr/" . $image)) {
    $page_content .= '
        <img src="api/qr/' . htmlspecialchars($image) . '" 
             alt="QR Code" 
             style="max-width:300px;width:100%;height:auto;margin-bottom:20px;">';
}

$page_content .= '
                <form method="POST" action="">
                    <div class="form-group mt-3">
                        <label for="qrcode">Novo QR Code (URL ou texto):</label>
                        <input type="text"
                               name="qrcode"
                               id="qrcode"
                               class="form-control"
                               value="' . htmlspecialchars($qrcode) . '"
                               required>
                    </div>
                    <button type="submit" name="submit" class="btn btn-primary mt-3">
                        Atualizar QR Code
                    </button>
                </form>
            </center>
        </div>
    </div>
</div>';

include 'includes/layout.php';
