<?php
// Get the server's base URL
function getBaseUrl() {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'];
    $path = dirname($_SERVER['REQUEST_URI']);
    // Remove '/api' from the path if this script is in the api folder
    $path = rtrim(str_replace('/api', '', $path), '/');
    return $protocol . $host . $path;
}

// Create relative paths and reconstruct with base URL
$baseUrl = getBaseUrl();
$apiPath = "api/api.php";
$dnsPath = "api/dns.php";

$basesbpurl = $baseUrl . "/" . $apiPath;
$securityurl = $baseUrl . "/" . $dnsPath;
$clientsbpurl = $baseUrl . "/" . $apiPath;

$response = [
    "data" => [
        "getSmartersProAll" => [
            "__typename" => "SmartersProAll",
            "id" => "6f89a48b-f4b7-4ff9-8400-9feb1792bf7e",
            "basesbpurl" => $basesbpurl,
            "securityurl" => $securityurl,
            "clientsbpurl" => $clientsbpurl,
            "config1" => "https://smartersapi-android.servep2p.com/?/Android",
            "config2" => "",
            "config3" => "",
            "config4" => "",
            "config5" => "",
            "createdAt" => "2023-12-06T12:23:55.846Z",
            "updatedAt" => "2023-12-06T12:23:55.846Z"
        ]
    ]
];

header('Content-Type: application/json');
echo json_encode($response);
?>