<?php
header('Content-Type: application/json');

// Configurações do banco de dados
$dbPath = __DIR__ . '/studiolivecode.db';

if (!file_exists($dbPath)) {
    echo json_encode(['error' => 'Database file not found']);
    exit;
}

try {
    $adb = new SQLite3($dbPath, SQLITE3_OPEN_READWRITE);
    $adb->enableExceptions(true);

    $data = json_decode(file_get_contents('php://input'), true);
    $codigo = $data['codigo'] ?? '';
    $mac_address = $data['mac_address'] ?? '';

    if (!empty($codigo) && !empty($mac_address)) {
        // Busca o código na tabela
        $stmt = $adb->prepare("SELECT id, dns_id, m3u_url, mac_address FROM codes WHERE code = :code");
        $stmt->bindValue(':code', $codigo, SQLITE3_TEXT);
        $result = $stmt->execute();
        $row = $result->fetchArray(SQLITE3_ASSOC);

        if ($row) {
            if (empty($row['mac_address'])) {
                // Se não existe MAC cadastrado ainda, cadastra este primeiro MAC automaticamente
                $updateStmt = $adb->prepare("UPDATE codes SET mac_address = :mac_address WHERE id = :id");
                $updateStmt->bindValue(':mac_address', $mac_address, SQLITE3_TEXT);
                $updateStmt->bindValue(':id', $row['id'], SQLITE3_INTEGER);
                $updateStmt->execute();

                // Inserir na playlist
                $parsed_url = parse_url($row['m3u_url']);
                parse_str($parsed_url['query'] ?? '', $query_params);
                $username = $query_params['username'] ?? 'default';
                $password = $query_params['password'] ?? 'default';

                $insertStmt = $adb->prepare("INSERT INTO playlist 
                    (dns_id, mac_address, username, password, pin, link, type, url) 
                    VALUES (:dns_id, :mac_address, :username, :password, :pin, :link, :type, :url)");

                $insertStmt->bindValue(':dns_id', $row['dns_id'], SQLITE3_INTEGER);
                $insertStmt->bindValue(':mac_address', $mac_address, SQLITE3_TEXT);
                $insertStmt->bindValue(':username', $username, SQLITE3_TEXT);
                $insertStmt->bindValue(':password', $password, SQLITE3_TEXT);
                $insertStmt->bindValue(':pin', '0000', SQLITE3_TEXT);
                $insertStmt->bindValue(':link', '', SQLITE3_TEXT);
                $insertStmt->bindValue(':type', 'm3u', SQLITE3_TEXT);
                $insertStmt->bindValue(':url', $row['m3u_url'], SQLITE3_TEXT);
                $insertStmt->execute();

                echo json_encode([
                    'existe' => true,
                    'm3u_url' => $row['m3u_url'],
                    'mensagem' => 'MAC cadastrado e acesso liberado.'
                ]);
            } else {
                // Se já existe MAC cadastrado
                if ($row['mac_address'] === $mac_address) {
                    echo json_encode([
                        'existe' => true,
                        'm3u_url' => $row['m3u_url'],
                        'mensagem' => 'MAC autorizado, acesso liberado.'
                    ]);
                } else {
                    echo json_encode([
                        'existe' => false,
                        'mensagem' => 'Este código já está em uso por outro dispositivo.'
                    ]);
                }
            }
        } else {
            echo json_encode([
                'existe' => false,
                'mensagem' => 'Código inválido.'
            ]);
        }

    } elseif (!empty($mac_address)) {
        // Consulta direta por MAC caso venha sem código
        $stmt = $adb->prepare("SELECT m3u_url FROM codes WHERE mac_address = :mac_address");
        $stmt->bindValue(':mac_address', $mac_address, SQLITE3_TEXT);
        $result = $stmt->execute();
        $row = $result->fetchArray(SQLITE3_ASSOC);

        if ($row) {
            echo json_encode([
                'existe' => true,
                'm3u_url' => $row['m3u_url'],
                'mensagem' => 'MAC encontrado, acesso liberado.'
            ]);
        } else {
            echo json_encode([
                'existe' => false,
                'mensagem' => 'MAC não autorizado.'
            ]);
        }
    } else {
        throw new Exception("Nenhum dado fornecido para consulta.");
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
