<?php
// cadastro_sucesso.php

ini_set("display_errors", 1);
error_reporting(E_ALL);

// Carrega a configuração do package
$config = require __DIR__ . '/config_package.php';
$package = $config['package_name'];

// Pegar os dados da URL
$mac = $_GET['mac'] ?? '';
$usuario = $_GET['usuario'] ?? '';
$servidor = $_GET['servidor'] ?? '';

$jsonFile = __DIR__ . '/reset.json';

// Função para limpar o arquivo JSON (apagar conteúdo)
function limparJson($file) {
    file_put_contents($file, '');
}

// Função para gravar o comando no JSON
function gravarComando($file, $comando) {
    file_put_contents($file, json_encode($comando, JSON_PRETTY_PRINT));
}

// Lógica: se o arquivo já tiver conteúdo, limpa
// Se estiver vazio, grava o comando
$conteudoAtual = file_get_contents($jsonFile);

if (trim($conteudoAtual) !== '') {
    // Já tem conteúdo, então limpa para próxima vez
    limparJson($jsonFile);
} else {
    // Está vazio, então grava o comando no formato desejado
    $comando = [
        'reset' => true,
        'package' => $package // Usa o valor do arquivo de configuração
    ];

    gravarComando($jsonFile, $comando);

    // Adiciona um atraso de 1 segundo antes de limpar o JSON
    sleep(1);

    // Limpa o JSON imediatamente após o atraso
    limparJson($jsonFile);
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Cadastro Realizado com Sucesso</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            overflow: hidden;
            position: relative;
            background: #000;
        }
        
        #particles-js {
            position: absolute;
            width: 100%;
            height: 100%;
            background-color: #000;
            z-index: 1;
        }
        
        .success-container {
            background: linear-gradient(135deg, #1a1a1a 0%, #003300 100%);
            padding: 2rem;
            border-radius: 15px;
            width: 90%;
            max-width: 500px;
            margin: 2rem auto;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.5);
            position: relative;
            z-index: 2;
            border: 1px solid #33ff33;
            color: #fff;
            text-align: center;
        }
        
        h2 {
            color: #fff;
            margin-bottom: 1.5rem;
            font-size: 1.8rem;
            text-shadow: 0 2px 4px rgba(0, 255, 0, 0.5);
        }
        
        .success-icon {
            font-size: 4rem;
            color: #4CAF50;
            margin-bottom: 1rem;
            animation: bounce 1s infinite alternate;
        }
        
        .info-box {
            background: rgba(0, 0, 0, 0.3);
            border: 1px solid #33ff33;
            border-radius: 8px;
            padding: 1rem;
            margin: 1rem 0;
            text-align: left;
        }
        
        .info-item {
            margin: 0.5rem 0;
            display: flex;
        }
        
        .info-label {
            font-weight: bold;
            color: #33ff33;
            min-width: 120px;
        }
        
        .info-value {
            color: #fff;
        }
        
        .message {
            margin: 1.5rem 0;
            font-size: 1.1rem;
            line-height: 1.5;
        }
        
        .btn-back {
            display: inline-block;
            padding: 12px 24px;
            background: linear-gradient(to right, #33cc33, #009900);
            border: none;
            color: #fff;
            font-size: 1rem;
            border-radius: 8px;
            margin-top: 1.5rem;
            cursor: pointer;
            font-weight: bold;
            text-decoration: none;
            transition: all 0.3s;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.3);
        }
        
        .btn-back:hover {
            background: linear-gradient(to right, #44dd44, #00aa00);
            transform: translateY(-2px);
            box-shadow: 0 6px 8px rgba(0, 0, 0, 0.4);
        }
        
        @keyframes bounce {
            from {
                transform: translateY(0);
            }
            to {
                transform: translateY(-10px);
            }
        }
        
        @media (max-width: 480px) {
            .success-container {
                padding: 1.5rem;
                width: 95%;
            }
            
            h2 {
                font-size: 1.5rem;
            }
            
            .success-icon {
                font-size: 3rem;
            }
            
            .info-item {
                flex-direction: column;
            }
            
            .info-label {
                margin-bottom: 0.2rem;
            }
        }
    </style>
</head>
<body>
    <div id="particles-js"></div>
    
    <div class="success-container">
        <div class="success-icon">✓</div>
        <h2>Cadastro Realizado com Sucesso!</h2>
        
        <div class="info-box">
            <div class="info-item">
                <span class="info-label">Dispositivo:</span>
                <span class="info-value"><?php echo htmlspecialchars($mac); ?></span>
            </div>
            <div class="info-item">
                <span class="info-label">Usuário:</span>
                <span class="info-value"><?php echo htmlspecialchars($usuario); ?></span>
            </div>
            <div class="info-item">
                <span class="info-label">Servidor:</span>
                <span class="info-value"><?php echo htmlspecialchars($servidor); ?></span>
            </div>
            <div class="info-item">
                <span class="info-label">Package:</span>
                <span class="info-value"><?php echo htmlspecialchars($package); ?></span>
            </div>
        </div>
        
        <div class="message">
            Seu cadastro foi adicionado com sucesso à lista IPTV.<br>
            Bom aproveito e desfrute do melhor conteúdo!
        </div>
        
        <a href="cadastro_cliente.php" class="btn-back">Voltar ao Cadastro</a>
    </div>

    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            particlesJS('particles-js', {
                "particles": {
                    "number": {
                        "value": 80,
                        "density": {
                            "enable": true,
                            "value_area": 800
                        }
                    },
                    "color": {
                        "value": "#00ff00"
                    },
                    "shape": {
                        "type": "circle",
                        "stroke": {
                            "width": 0,
                            "color": "#000000"
                        },
                        "polygon": {
                            "nb_sides": 5
                        }
                    },
                    "opacity": {
                        "value": 0.5,
                        "random": false,
                        "anim": {
                            "enable": false,
                            "speed": 1,
                            "opacity_min": 0.1,
                            "sync": false
                        }
                    },
                    "size": {
                        "value": 3,
                        "random": true,
                        "anim": {
                            "enable": false,
                            "speed": 40,
                            "size_min": 0.1,
                            "sync": false
                        }
                    },
                    "line_linked": {
                        "enable": true,
                        "distance": 150,
                        "color": "#33ff33",
                        "opacity": 0.4,
                        "width": 1
                    },
                    "move": {
                        "enable": true,
                        "speed": 2,
                        "direction": "none",
                        "random": false,
                        "straight": false,
                        "out_mode": "out",
                        "bounce": false,
                        "attract": {
                            "enable": false,
                            "rotateX": 600,
                            "rotateY": 1200
                        }
                    }
                },
                "interactivity": {
                    "detect_on": "canvas",
                    "events": {
                        "onhover": {
                            "enable": true,
                            "mode": "grab"
                        },
                        "onclick": {
                            "enable": true,
                            "mode": "push"
                        },
                        "resize": true
                    },
                    "modes": {
                        "grab": {
                            "distance": 140,
                            "line_linked": {
                                "opacity": 1
                            }
                        },
                        "bubble": {
                            "distance": 400,
                            "size": 40,
                            "duration": 2,
                            "opacity": 8,
                            "speed": 3
                        },
                        "repulse": {
                            "distance": 200,
                            "duration": 0.4
                        },
                        "push": {
                            "particles_nb": 4
                        },
                        "remove": {
                            "particles_nb": 2
                        }
                    }
                },
                "retina_detect": true
            });
        });
    </script>
</body>
</html>