<?php
/*
 * 🎵 @ Playlist Manager - Dashboard
 * 🚀 @ Version: 1.0.0
 * 📅 @ Last Updated: 28/06/2025
 */

include "includes/header.php";
?>

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12 text-center mb-4">
            <h2><i class="fas fa-home"></i> Dashboard Principal</h2>
            <p class="lead">Bem-vindo ao painel de gerenciamento de playlists e configurações do sistema.</p>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-primary text-white">
                <div class="card-body">
                    <i class="fas fa-users fa-3x mb-3"></i>
                    <h5 class="card-title">Gerenciar Playlists</h5>
                    <p class="card-text">Adicione, edite ou remova usuários e suas playlists.</p>
                    <a href="playlists.php" class="btn btn-light btn-block">Acessar Playlists</a>
                </div>
            </div>
        </div>

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-info text-white">
                <div class="card-body">
                    <i class="fas fa-server fa-3x mb-3"></i>
                    <h5 class="card-title">Servidores de DNS</h5>
                    <p class="card-text">Gerencie os servidores DNS para suas playlists.</p>
                    <a href="dns.php" class="btn btn-light btn-block">Acessar DNS</a>
                </div>
            </div>
        </div>

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-warning text-white">
                <div class="card-body">
                    <i class="fas fa-ad fa-3x mb-3"></i>
                    <h5 class="card-title">Enviar Anúncios</h5>
                    <p class="card-text">Configure e envie anúncios para seus usuários.</p>
                    <a href="ads.php" class="btn btn-light btn-block">Acessar Anúncios</a>
                </div>
            </div>
        </div>

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-secondary text-white">
                <div class="card-body">
                    <i class="fas fa-cog fa-3x mb-3"></i>
                    <h5 class="card-title">Autoads/Manual</h5>
                    <p class="card-text">Gerencie as configurações de anúncios automáticos e manuais.</p>
                    <a href="mRTXAdsSetting.php" class="btn btn-light btn-block">Acessar Configurações</a>
                </div>
            </div>
        </div>

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-dark text-white">
                <div class="card-body">
                    <i class="fas fa-palette fa-3x mb-3"></i>
                    <h5 class="card-title">Selecionar Tema</h5>
                    <p class="card-text">Personalize o tema da sua aplicação.</p>
                    <a href="themes.php" class="btn btn-light btn-block">Selecionar Tema</a>
                </div>
            </div>
        </div>

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-success text-white">
                <div class="card-body">
                    <i class="fas fa-comment-alt fa-3x mb-3"></i>
                    <h5 class="card-title">Mensagem Servidores</h5>
                    <p class="card-text">Envie mensagens para os servidores.</p>
                    <a href="settings.php" class="btn btn-light btn-block">Configurar Mensagens</a>
                </div>
            </div>
        </div>

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-danger text-white">
                <div class="card-body">
                    <i class="fas fa-paint-brush fa-3x mb-3"></i>
                    <h5 class="card-title">Personalizar App</h5>
                    <p class="card-text">Acesse as opções de personalização do aplicativo.</p>
                    <a href="#" class="btn btn-light btn-block" data-toggle="modal" data-target="#customizeModal">Personalizar App</a>
                </div>
            </div>
        </div>

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-info text-white">
                <div class="card-body">
                    <i class="fas fa-qrcode fa-3x mb-3"></i>
                    <h5 class="card-title">Alterar QR Code</h5>
                    <p class="card-text">Atualize o código QR do seu sistema.</p>
                    <a href="qrcode.php" class="btn btn-light btn-block">Alterar QR Code</a>
                </div>
            </div>
        </div>

      <div class="col-md-4 col-sm-6 mb-4">
    <div class="card text-center bg-primary text-white">
        <div class="card-body">
            <i class="fas fa-code fa-3x mb-3"></i> <h5 class="card-title">Gerenciar Codigos</h5>
            <p class="card-text">Visualize edite e organize seus codigos fonte.</p>
            <a href="gerenciador.php" class="btn btn-light btn-block">Acessar Gerenciador</a>
        </div>
    </div>
</div>

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-warning text-white">
                <div class="card-body">
                    <i class="fas fa-money-bill-wave fa-3x mb-3"></i>
                    <h5 class="card-title">Pagamento</h5>
                    <p class="card-text">Gerencie as configurações de pagamento.</p>
                    <a href="pagamento.php" class="btn btn-light btn-block">Acessar Pagamento</a>
                </div>
            </div>
        </div>

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-dark text-white">
                <div class="card-body">
                    <i class="fas fa-user-cog fa-3x mb-3"></i>
                    <h5 class="card-title">Meu Perfil</h5>
                    <p class="card-text">Acesse e gerencie suas informações de perfil.</p>
                    <a href="user.php" class="btn btn-light btn-block">Acessar Perfil</a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include "includes/footer.php"; ?>