<?php
ini_set('display_errors', 1);
include('includes/header.php');

// Caminho do arquivo JSON
$jsonFile = 'cores.json';

// Verificar se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obter os novos valores do formulário
    $newStartColor = $_POST['start_color'];
    $newEndColor = $_POST['end_color'];
    $newBorderColor = $_POST['border_color'];
    $newBorderColorFocus  = $_POST['border_color_focus'];
    $newBorderWidth = (int)$_POST['border_width'];
    $newCornerRadius = (int)$_POST['corner_radius'];

    // Criar um array com as novas configurações
    $newColors = [
        "START_COLOR_XML" => $newStartColor,
        "END_COLOR_XML" => $newEndColor,
        "BORDER_COLOR_NORMAL" => $newBorderColor,
        "BORDER_COLOR_FOCUS" => $newBorderColorFocus,
        "BORDER_WIDTH_DP" => $newBorderWidth,
        "CORNER_RADIUS_DP" => $newCornerRadius
    ];

    // Atualizar o arquivo JSON com os novos valores
    file_put_contents($jsonFile, json_encode($newColors, JSON_PRETTY_PRINT));
}

// Carregar as configurações atuais do arquivo JSON
$cores = json_decode(file_get_contents($jsonFile), true);
?>

<div class="col-md-6 mx-auto">
    <div class="card-body">
        <div class="card ctcard">
            <div class="card-header">
                <center>
                    <h2><i class="fa fa-paint-brush"></i> Alterar Cores e Estilos</h2>
                </center>
            </div>
            <div class="card-body">
                <form method="POST">
                    <div class="form-group">
                        <label for="start_color">Cor de Início:</label>
                        <input type="color" class="form-control" name="start_color" value="<?php echo htmlspecialchars($cores['START_COLOR_XML']); ?>">
                    </div>

                    <div class="form-group">
                        <label for="end_color">Cor de Fim:</label>
                        <input type="color" class="form-control" name="end_color" value="<?php echo htmlspecialchars($cores['END_COLOR_XML']); ?>">
                    </div>
                     <div class="form-group">
                        <label for="border_color">Cor da Borda Forma:</label>
                        <input type="color" class="form-control" name="border_color_focus" value="<?php echo htmlspecialchars($cores['BORDER_COLOR_FOCUS']); ?>">
                    </div>
                    <div class="form-group">
                        <label for="border_color">Cor da Borda:</label>
                        <input type="color" class="form-control" name="border_color" value="<?php echo htmlspecialchars($cores['BORDER_COLOR_NORMAL']); ?>">
                    </div>

                    <div class="form-group">
                        <label for="border_width">Largura da Borda (em px):</label>
                        <input type="number" class="form-control" name="border_width" value="<?php echo htmlspecialchars($cores['BORDER_WIDTH_DP']); ?>" min="1">
                    </div>

                    <div class="form-group">
                        <label for="corner_radius">Raio das Bordas (em px):</label>
                        <input type="number" class="form-control" name="corner_radius" value="<?php echo htmlspecialchars($cores['CORNER_RADIUS_DP']); ?>" min="0">
                    </div>

                    <button type="submit" class="btn btn-success">Salvar Alterações</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>

</body>
</html>
