<?php
session_start();
ini_set("display_errors", 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    unset($_SESSION['wizard']);
}

include "includes/header.php";

$adb = new SQLite3('./api/studiolivecode.db');

if (!isset($_SESSION['wizard'])) {
    $_SESSION['wizard'] = [
        'step' => 1,
        'data' => [
            'cliente' => '',
            'm3u_url' => '',    // Link M3U completo (digitado pelo usuário)
            'dns_id' => '',
            'mac_address' => '', // MAC Address inicializado
            'username' => '',
            'password' => '',
            'pin' => '',        // PIN: será fixo '0000'
            'base_url' => '',   // Não será usado para 'link' na playlist
            'type' => 'm3u'     // Tipo da playlist (ex: 'm3u')
        ]
    ];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'next_step':
                handleNextStep();
                break;
            case 'prev_step':
                $_SESSION['wizard']['step']--;
                break;
            case 'finish':
                handleFinish();
                break;
        }
    }
}

function handleNextStep() {
    $current_step = $_SESSION['wizard']['step'];
    $errors = [];

    switch ($current_step) {
        case 1:
            if (empty($_POST['cliente'])) {
                $errors[] = "O nome do cliente é obrigatório.";
            } else {
                $_SESSION['wizard']['data']['cliente'] = trim($_POST['cliente']);
            }
            break;
        case 2:
            if (empty($_POST['m3u_url'])) {
                $errors[] = "A URL M3U é obrigatória.";
            } else {
                $m3u_url = trim($_POST['m3u_url']);
                $_SESSION['wizard']['data']['m3u_url'] = $m3u_url; // Salva a URL M3U completa

                // Tentar extrair username, password e a base_url
                if (preg_match('/^(https?:\/\/[^\/:]+(?::\d+)?)\/[^\?]*\??(?:username=([^&]+))?(?:&password=([^&]+))?/i', $m3u_url, $matches)) {
                    $_SESSION['wizard']['data']['base_url'] = $matches[1] . '/';
                    $_SESSION['wizard']['data']['username'] = isset($matches[2]) ? $matches[2] : '';
                    $_SESSION['wizard']['data']['password'] = isset($matches[3]) ? $matches[3] : '';

                    error_log("DEBUG: M3U URL Completa: " . $m3u_url);
                    error_log("DEBUG: Base URL Extraída: " . $_SESSION['wizard']['data']['base_url']);
                    error_log("DEBUG: Username Extraído: " . $_SESSION['wizard']['data']['username']);
                    error_log("DEBUG: Password Extraído: " . $_SESSION['wizard']['data']['password']);

                } else {
                    $_SESSION['wizard']['data']['base_url'] = '';
                    $_SESSION['wizard']['data']['username'] = '';
                    $_SESSION['wizard']['data']['password'] = '';
                    error_log("DEBUG: Não foi possível extrair base_url/username/password da URL: " . $m3u_url);
                }
            }
            break;
        case 3:
            if (empty($_POST['dns_id'])) {
                $errors[] = "Selecione uma Conexão DNS.";
            } else {
                $_SESSION['wizard']['data']['dns_id'] = $_POST['dns_id'];
            }
            break;
        case 4:
            error_log("DEBUG: Valor de POST['mac_address'] no Passo 4: '" . (isset($_POST['mac_address']) ? $_POST['mac_address'] : 'NÃO DEFINIDO') . "'");

            $macInput = isset($_POST['mac_address']) ? (string)trim($_POST['mac_address']) : '';

            if (!empty($macInput)) {
                if (!preg_match('/^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$/', $macInput)) {
                    $errors[] = "Formato de MAC Address inválido. Use XX:XX:XX:XX:XX:XX ou XX-XX-XX-XX-XX-XX.";
                } else {
                    $_SESSION['wizard']['data']['mac_address'] = $macInput;
                }
            } else {
                $_SESSION['wizard']['data']['mac_address'] = ''; // Garante que seja string vazia se não preenchido
            }
            break;
        case 5:
            // Este passo agora é o Resumo Final ANTES de Salvar
            break;
    }

    if (empty($errors)) {
        $_SESSION['wizard']['step']++;
    } else {
        foreach ($errors as $error) {
            echo "<div class='alert alert-danger'>⚠️ $error</div>";
        }
    }
}

function handleFinish() {
    global $adb;

    // DEBUG: Verifica os valores finais na sessão antes de finalizar
    error_log("DEBUG: MAC Address na sessão (handleFinish) antes de showResult: '" . $_SESSION['wizard']['data']['mac_address'] . "'");
    error_log("DEBUG: M3U URL Completa na sessão: '" . $_SESSION['wizard']['data']['m3u_url'] . "'");
    error_log("DEBUG: Username na sessão: '" . $_SESSION['wizard']['data']['username'] . "'");
    error_log("DEBUG: Password na sessão: '" . $_SESSION['wizard']['data']['password'] . "'");

    // Gerar o código de ativação para a tabela 'codes'
    do {
        $codigo = str_pad(mt_rand(0, 9999), 4, '0', STR_PAD_LEFT);
        $stmt = $adb->prepare("SELECT COUNT(*) FROM codes WHERE code = :code");
        $stmt->bindValue(':code', $codigo, SQLITE3_TEXT);
        $exists = $stmt->execute()->fetchArray()[0];
    } while ($exists);

    // PIN fixo '0000'
    $pin = '0000';
    $_SESSION['wizard']['data']['pin'] = $pin; // Salva na sessão para exibição no showResult

    $adb->exec('BEGIN TRANSACTION;'); // Inicia uma transação

    // --- INSERÇÃO NA TABELA 'codes' (SEMPRE ACONTECE) ---
    $stmt_codes = $adb->prepare("INSERT INTO codes (dns_id, code, m3u_url, mac_address, cliente)
                                 VALUES (:dns_id, :code, :m3u_url, :mac_address, :cliente)");
    $stmt_codes->bindValue(':dns_id', $_SESSION['wizard']['data']['dns_id'], SQLITE3_INTEGER);
    $stmt_codes->bindValue(':code', $codigo, SQLITE3_TEXT);
    $stmt_codes->bindValue(':m3u_url', $_SESSION['wizard']['data']['m3u_url'], SQLITE3_TEXT);
    $stmt_codes->bindValue(':mac_address', $_SESSION['wizard']['data']['mac_address'], SQLITE3_TEXT);
    $stmt_codes->bindValue(':cliente', $_SESSION['wizard']['data']['cliente'], SQLITE3_TEXT);

    $success_codes = $stmt_codes->execute();
    $success_playlist = true; // Assume sucesso inicial para playlist

    // --- INSERÇÃO NA TABELA 'playlist' (APENAS SE MAC ADDRESS FOR PREENCHIDO) ---
    if (!empty($_SESSION['wizard']['data']['mac_address'])) {
        error_log("DEBUG: MAC Address preenchido. Inserindo na tabela 'playlist'. MAC: " . $_SESSION['wizard']['data']['mac_address']);
        $stmt_playlist = $adb->prepare("INSERT INTO playlist (dns_id, mac_address, username, password, pin, link, type, url, cliente)
                                       VALUES (:dns_id, :mac_address, :username, :password, :pin, :link_val, :type, :url_playlist, :cliente)");
        $stmt_playlist->bindValue(':dns_id', $_SESSION['wizard']['data']['dns_id'], SQLITE3_INTEGER);
        $stmt_playlist->bindValue(':mac_address', $_SESSION['wizard']['data']['mac_address'], SQLITE3_TEXT);
        $stmt_playlist->bindValue(':username', $_SESSION['wizard']['data']['username'], SQLITE3_TEXT);
        $stmt_playlist->bindValue(':password', $_SESSION['wizard']['data']['password'], SQLITE3_TEXT);
        $stmt_playlist->bindValue(':pin', $_SESSION['wizard']['data']['pin'], SQLITE3_TEXT);
        $stmt_playlist->bindValue(':link_val', '', SQLITE3_TEXT); // 'link' recebe string vazia ''
        $stmt_playlist->bindValue(':type', $_SESSION['wizard']['data']['type'], SQLITE3_TEXT);
        $stmt_playlist->bindValue(':url_playlist', $_SESSION['wizard']['data']['m3u_url'], SQLITE3_TEXT); // 'url' recebe a URL M3U completa
        $stmt_playlist->bindValue(':cliente', $_SESSION['wizard']['data']['cliente'], SQLITE3_TEXT);

        $success_playlist = $stmt_playlist->execute();
    } else {
        error_log("DEBUG: MAC Address NÃO preenchido. Pulando inserção na tabela 'playlist'.");
    }

    if ($success_codes && $success_playlist) {
        $adb->exec('COMMIT;'); // Confirma as inserções
        showResult($codigo);
        $_SESSION['wizard'] = null;
        return;
    } else {
        $adb->exec('ROLLBACK;'); // Desfaz as inserções em caso de erro
        $errorMessage = "Erro ao cadastrar no banco de dados. ";
        if (!$success_codes) $errorMessage .= "Erro em 'codes': " . $adb->lastErrorMsg() . ". ";
        if (!$success_playlist) $errorMessage .= "Erro em 'playlist': " . $adb->lastErrorMsg() . ". ";
        echo "<div class='alert alert-danger'>⚠️ $errorMessage</div>";
        $_SESSION['wizard']['step'] = 1;
    }
}

function showResult($codigo) {
    global $adb;

    $cliente = htmlspecialchars($_SESSION['wizard']['data']['cliente']);
    $dns_title = htmlspecialchars(getDnsTitle($_SESSION['wizard']['data']['dns_id']));
    $mac = htmlspecialchars($_SESSION['wizard']['data']['mac_address'] ?: 'Não informado');
    $username_display = htmlspecialchars($_SESSION['wizard']['data']['username'] ?: 'N/A');
    $password_display = htmlspecialchars($_SESSION['wizard']['data']['password'] ?: 'N/A');
    $m3u_url_display = htmlspecialchars($_SESSION['wizard']['data']['m3u_url'] ?: 'N/A');
    $pin_display = htmlspecialchars($_SESSION['wizard']['data']['pin'] ?: 'N/A');

    // Mensagem condicional para a playlist
    $playlist_status_message = "";
    if (empty($_SESSION['wizard']['data']['mac_address'])) {
        $playlist_status_message = "<p class='text-danger'>⚠️ Nenhuma entrada na tabela 'playlist' foi criada pois o MAC Address não foi informado.</p>";
    } else {
        $playlist_status_message = <<<HTML
            <h5>▶️ Dados da Playlist (Salvos no Banco):</h5>
            <p><strong>Usuário:</strong> $username_display</p>
            <p><strong>Senha:</strong> $password_display</p>
            <p><strong>URL M3U Completa:</strong> <small>$m3u_url_display</small></p>
            <p><strong>PIN:</strong> $pin_display</p>
            <p><strong>Coluna 'link':</strong> Não preenchida</p>
        HTML;
    }


    echo <<<HTML
    <div class="container">
        <div class="card text-center">
            <div class="card-header bg-success text-white">
                <h3>✅ Cadastro Concluído!</h3>
            </div>
            <div class="card-body">
                <h4>Seu código de ativação é:</h4>
                <div class="display-2 font-weight-bold my-4">$codigo</div>
                <div class="alert alert-info text-left">
                    <h5>📋 Informações do Cadastro:</h5>
                    <p><strong>👤 Cliente:</strong> $cliente</p>
                    <p><strong>🌐 DNS:</strong> $dns_title</p>
                    <p><strong>📡 MAC Address:</strong> $mac</p>
                    <hr>
                    $playlist_status_message
                </div>
                <a href="tutorial.php" class="btn btn-primary">➕ Novo Cadastro</a>
                <a href="gerenciador.php" class="btn btn-secondary">📋 Ver Todos os Códigos</a>
            </div>
        </div>
    </div>
HTML;
    include "includes/footer.php";
    exit;
}

function getDnsTitle($dns_id) {
    global $adb;
    $stmt = $adb->prepare("SELECT title FROM dns WHERE id = :id");
    $stmt->bindValue(':id', $dns_id, SQLITE3_INTEGER);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    return $row['title'];
}

$dns_options = $adb->query("SELECT id, title FROM dns ORDER BY title ASC");
?>

<div class="container">
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">📝 Cadastro de Código - Passo <?= $_SESSION['wizard']['step'] ?> de 5</h4>
        </div>
        <div class="card-body">
            <div class="progress mb-4">
                <?php for ($i = 1; $i <= 5; $i++): ?>
                    <div class="progress-bar <?= $i <= $_SESSION['wizard']['step'] ? 'bg-success' : '' ?>" style="width: 20%">
                        Passo <?= $i ?>
                    </div>
                <?php endfor; ?>
            </div>
            <form method="post">
                <?php switch ($_SESSION['wizard']['step']):
                    case 1: ?>
                        <div class="form-group">
                            <label>👤 Nome do Cliente:</label>
                            <input type="text" class="form-control" name="cliente" required value="<?= htmlspecialchars($_SESSION['wizard']['data']['cliente']) ?>">
                        </div>
                        <input type="hidden" name="action" value="next_step">
                        <button type="submit" class="btn btn-primary float-right">Próximo →</button>
                        <?php break; ?>
                    <?php case 2: ?>
                        <div class="form-group">
                            <label>🔗 URL M3U:</label>
                            <textarea class="form-control" name="m3u_url" rows="3" required><?= htmlspecialchars($_SESSION['wizard']['data']['m3u_url']) ?></textarea>
                            <small class="text-muted">Exemplo: http://servidor.com/get.php?username=123&password=456</small>
                        </div>
                        <input type="hidden" name="action" value="next_step">
                        <div class="d-flex justify-content-between">
                            <button type="submit" name="action" value="prev_step" class="btn btn-secondary">← Voltar</button>
                            <button type="submit" class="btn btn-primary">Próximo →</button>
                        </div>
                        <?php break; ?>
                    <?php case 3: ?>
                        <div class="form-group">
                            <label>🌐 Conexão DNS:</label>
                            <select class="form-control" name="dns_id" required>
                                <option value="">Selecione...</option>
                                <?php while ($dns = $dns_options->fetchArray()): ?>
                                    <option value="<?= $dns['id'] ?>" <?= ($_SESSION['wizard']['data']['dns_id'] == $dns['id']) ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($dns['title']) ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <input type="hidden" name="action" value="next_step">
                        <div class="d-flex justify_content_between">
                            <button type="submit" name="action" value="prev_step" class="btn btn-secondary">← Voltar</button>
                            <button type="submit" class="btn btn-primary">Próximo →</button>
                        </div>
                        <?php break; ?>
                    <?php case 4: ?>
                        <div class="form-group">
                            <label>📡 MAC Address (Opcional):</label>
                            <input type="text" class="form-control" name="mac_address" placeholder="Ex: A1:B2:C3:D4:E5:F6" pattern="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" value="<?= htmlspecialchars($_SESSION['wizard']['data']['mac_address']) ?>">
                            <small class="text-muted">Formato: XX:XX:XX:XX:XX:XX</small>
                        </div>
                        <input type="hidden" name="action" value="next_step">
                        <div class="d-flex justify-content-between">
                            <button type="submit" name="action" value="prev_step" class="btn btn-secondary">← Voltar</button>
                            <button type="submit" class="btn btn-primary">Próximo →</button>
                        </div>
                        <?php break; ?>
                    <?php case 5: ?>
                        <div class="alert alert-info mt-4">
                            <h5>📋 Resumo Final do Cadastro:</h5>
                            <p><strong>👤 Cliente:</strong> <?= htmlspecialchars($_SESSION['wizard']['data']['cliente']) ?></p>
                            <p><strong>🔗 URL M3U Completa:</strong> <small><?= htmlspecialchars($_SESSION['wizard']['data']['m3u_url']) ?></small></p>
                            <p><strong>🌐 DNS:</strong> <?= getDnsTitle($_SESSION['wizard']['data']['dns_id']) ?></p>
                            <p><strong>📡 MAC Address:</strong> <?= htmlspecialchars($_SESSION['wizard']['data']['mac_address'] ?: 'Não informado') ?></p>
                            <hr>
                            <p>✅ Ao finalizar, os dados da playlist serão gravados (se o MAC Address for informado).</p>
                        </div>
                        <div class="d-flex justify-content-between">
                            <button type="submit" name="action" value="prev_step" class="btn btn-secondary">← Voltar</button>
                            <button type="submit" name="action" value="finish" class="btn btn-success">✅ Finalizar Cadastro</button>
                        </div>
                        <?php break; ?>
                <?php endswitch; ?>
            </form>
        </div>
    </div>
</div>

<?php include "includes/footer.php"; ?>