<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include(__DIR__ . '/functions.php'); // DB único /api/.db.db

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Usuário principal (id = 1)
$log_check = $db->select('user', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? ($log_check[0]['username'] ?? null) : null;

// Validação de sessão
if (empty($_SESSION['name']) || $_SESSION['name'] !== $loggedinuser) {
    header("Location: index.php");
    exit();
}

// Logout
if (isset($_REQUEST['logout'])) {
    session_unset();
    session_destroy();
    setcookie("auth", "", time() - 3600, "/");
    header("Location: index.php");
    exit();
}

// Timeout (15 minutos)
$timeout_duration = 900;
if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY']) > $timeout_duration) {
    session_unset();
    session_destroy();
    session_start();
    header("Location: index.php");
    exit();
}
$_SESSION['LAST_ACTIVITY'] = time();

function sanitize($data) {
    $data = trim($data);
    $data = htmlspecialchars($data, ENT_QUOTES);
    return SQLite3::escapeString($data);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>wave</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="NL">

    <link rel="icon" type="image/x-icon" href="./img/favicon.ico">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <link href="css/themes/darkly/bootstrap.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="css/simple-sidebar.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <style>
        /* Separador do menu lateral */
        .sidebar-separator {
            border: 0;
            height: 1px;
            margin: 8px 10px;
            background: linear-gradient(
                to right,
                transparent,
                rgba(255,255,255,0.35),
                transparent
            );
        }
    </style>
</head>

<div id="net-canvas"></div>
<body>
<div class="d-flex" id="wrapper">

    <!-- Sidebar -->
    <div id="sidebar-wrapper">
        <div class="sidebar-heading">
            <div class="sidebar-logo">
                <img src="https://i.postimg.cc/J0D6FfFT/splash-logo.png" alt="logo">
            </div>
        </div>

        <div class="list-group list-group-flush">

            <!-- DNS -->
            <a class="list-group-item list-group-item-action" href="main.php">
                <i class="fa fa-cogs"></i>&nbsp;&nbsp; Servidores DNS
            </a>

            <hr class="sidebar-separator">

            <!-- USER -->
            <a class="list-group-item list-group-item-action" href="user.php">
                <i class="fa fa-user"></i>&nbsp;&nbsp; Perfil
            </a>

        </div>
    </div>
    <!-- /Sidebar -->

    <!-- Page Content -->
    <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg navbar-dark ctnav">
            <button class="btn btn-primary" id="menu-toggle">
                <i class="fa fa-bars"></i>
            </button>

            <div class="center" id="pageMessages"></div>

            <a href="<?= basename($_SERVER["SCRIPT_NAME"]) . '?logout' ?>"
               class="btn btn-danger ml-auto mr-1">
                <i class="fa fa-sign-out"></i> Logout
            </a>
        </nav>

        <div class="container-fluid">
            <br>

            <style>
                body {
                    background-color: #181828;
                    background-image: url("./img/binding_dark.webp");
                    color: #fff;
                }
                #pageMessages {
                    left: 50%;
                    transform: translateX(-50%);
                    position: fixed;
                    top: 5px;
                    width: 60%;
                    z-index: 9999;
                }
            </style>

            <script src="./js/custom.js"></script>
            <script src="./js/three.min.js"></script>
            <script src="./js/vanta.net.min.js"></script>