<?php
include('includes/header.php');

// nome da tabela
$table_name = "dns";
$page = "main.php";

// ====== FUNÇÃO: GERAR API/portals.json ======
function syncPortalsJson($db, $table_name)
{
    // Ajuste o caminho se seu main.php estiver em outra pasta
    $apiDir  = __DIR__ . "/api";
    $apiFile = $apiDir . "/portals.json";

    // Busca todos os registros
    $rows = $db->select($table_name, '*', '', '');

    // Monta o array no formato solicitado
    $portals = [];
    $i = 0;

    if (is_array($rows)) {
        foreach ($rows as $r) {
            $portals[] = [
                "id"      => $i++, // sequencial 0,1,2...
                "name"    => $r["title"] ?? "",
                "url"     => $r["url"] ?? "",
                "epg_url" => $r["epg_url"] ?? ""
            ];
        }
    }

    $payload = ["portals" => $portals];

    // Cria pasta API se não existir
    if (!is_dir($apiDir)) {
        @mkdir($apiDir, 0755, true);
    }

    // Grava JSON com formatação bonita
    $json = json_encode($payload, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

    if ($json === false) {
        return false;
    }

    return (file_put_contents($apiFile, $json) !== false);
}

// chamada da tabela
$res = $db->select($table_name, '*', '', '');

// chamada de atualização
@$resU = $db->select($table_name, '*', 'id = :id', '', [':id' => $_GET['update']]);

if (isset($_POST['submitU'])) {
    unset($_POST['submitU']);

    $updateData = $_POST;

    // Segurança: garante que id não entra no updateData (já está no WHERE)
    unset($updateData['id']);

    $db->update($table_name, $updateData, 'id = :id', [':id' => $_GET['update']]);

    // Atualiza o portals.json
    syncPortalsJson($db, $table_name);

    echo "<script>window.location.href='" . $page . "?status=1'</script>";
    exit;
}

// envio de novo
if (isset($_POST['submit'])) {
    unset($_POST['submit']);

    $db->insert($table_name, $_POST);

    // Atualiza o portals.json
    syncPortalsJson($db, $table_name);

    $db->close();
    echo "<script>window.location.href='" . $page . "?status=1'</script>";
    exit;
}

// deletar linha
if (isset($_GET['delete'])) {
    $db->delete($table_name, 'id = :id', [':id' => $_GET['delete']]);

    // Atualiza o portals.json
    syncPortalsJson($db, $table_name);

    echo "<script>window.location.href='" . $page . "?status=2'</script>";
    exit;
}
?>

<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content" style="background-color: black;">
            <div class="modal-header">
                <h2 style="color: white;">Confirmação</h2>
            </div>
            <div class="modal-body" style="color: white;">
                Você realmente deseja excluir?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancelar</button>
                <a style="color: white;" class="btn btn-danger btn-ok">Excluir</a>
            </div>
        </div>
    </div>
</div>

<?php
if (isset($_GET['create'])) {
?>

    <div class="col-md-12 mx-auto ctmain-table">
        <div class="card-body">
            <div class="card ctcard">
                <div class="card-header card-header-warning">
                    <center>
                        <h2><i class="icon icon-bullhorn"></i> Entrada de DNS e Usuário</h2>
                    </center>
                </div>

                <div class="card-body">
                    <div class="col-12">
                        <h3>Adicionar DNS ou Usuário/Senha</h3>
                    </div>

                    <form method="post">
                        <div class="form-group ctinput">
                            <label class="form-label" for="title">Título</label>
                            <input class="form-control" name="title" placeholder="Título" type="text" required />
                        </div>

                        <div class="form-group ctinput">
                            <label class="form-label" for="dns">DNS</label>
                            <input class="form-control" name="url" placeholder="DNS" type="text" required />
                        </div>

                        <div class="form-group ctinput">
                            <label class="form-label" for="epg_url">EPG URL</label>
                            <input class="form-control" name="epg_url" placeholder="EPG URL (opcional)" type="text" />
                        </div>

                        <div class="form-group ctinput">
                            <center>
                                <button class="btn btn-info" name="submit" type="submit">
                                    <i class="icon icon-check"></i> Enviar
                                </button>
                            </center>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

<?php
} else if (isset($_GET['update'])) {
?>

    <div class="col-md-12 mx-auto ctmain-table">
        <div class="card-body">
            <div class="card ctcard">
                <div class="card-header card-header-warning">
                    <center>
                        <h2><i class="icon icon-bullhorn"></i> Entrada de DNS e Usuário</h2>
                    </center>
                </div>

                <div class="card-body">
                    <div class="col-12">
                        <h3>Editar DNS ou Usuário/Senha</h3>
                    </div>

                    <form method="post">
                        <input type="hidden" name="id" value="<?= $_GET['update'] ?>">

                        <div class="form-group ctinput">
                            <label class="form-label" for="title">Título</label>
                            <input class="form-control" name="title" placeholder="Título" value="<?= $resU[0]['title'] ?? '' ?>" type="text" required />
                        </div>

                        <div class="form-group ctinput">
                            <label class="form-label" for="dns">DNS</label>
                            <input class="form-control" name="url" placeholder="DNS" value="<?= $resU[0]['url'] ?? '' ?>" type="text" required />
                        </div>

                        <div class="form-group ctinput">
                            <label class="form-label" for="epg_url">EPG URL</label>
                            <input class="form-control" name="epg_url" placeholder="EPG URL (opcional)" value="<?= $resU[0]['epg_url'] ?? '' ?>" type="text" />
                        </div>

                        <div class="form-group ctinput">
                            <center>
                                <button class="btn btn-info" name="submitU" type="submit">
                                    <i class="icon icon-check"></i> Enviar
                                </button>
                            </center>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

<?php
} else {
?>

    <div class="col-md-12 mx-auto ctmain-table">
        <div class="card-body">
            <div class="card ctcard">
                <div class="card-header card-header-warning">
                    <center>
                        <h2><i class="icon icon-commenting"></i> DNSs e Usuários Atuais</h2>
                    </center>
                </div>

                <div class="card-body">
                    <div class="col-12">
                        <center>
                            <a id="button" href="./<?= $page ?>?create" class="btn btn-info">Novo DNS/Usuário</a>
                        </center>
                    </div>

                    <br>

                    <div class="table-responsive">
                        <table class="table table-striped table-sm">
                            <thead style="color:white!important">
                                <tr>
                                    <th>Título</th>
                                    <th>DNS</th>
                                    <th>EPG</th>
                                    <th>Editar&nbsp;&nbsp;&nbsp;Excluir</th>
                                </tr>
                            </thead>

                            <?php foreach ($res as $row) { ?>
                                <tbody>
                                    <tr>
                                        <td><?= $row['title'] ?></td>
                                        <td><?= $row['url'] ?></td>
                                        <td><?= $row['epg_url'] ?? '' ?></td>
                                        <td>
                                            <a class="btn btn-info btn-ok" href="<?= $page ?>?update=<?= $row['id'] ?>"><i class="fa fa-pencil-square-o"></i></a>
                                            &nbsp;&nbsp;&nbsp;
                                            <a class="btn btn-danger btn-ok" href="#" data-href="<?= $page ?>?delete=<?= $row['id'] ?>" data-toggle="modal" data-target="#confirm-delete"><i class="fa fa-trash-o"></i></a>
                                        </td>
                                    </tr>
                                </tbody>
                            <?php } ?>

                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>

<?php } ?>

<?php include('includes/footer.php'); ?>

</body>
</html>