
const bg = document.getElementById('waveBg');
const logo = document.getElementById('panelLogo');
const savedBg = localStorage.getItem('panel_bg');
const savedLogo = localStorage.getItem('panel_logo');
if (savedBg && bg) bg.style.backgroundImage = `url(${savedBg})`;
if (savedLogo && logo) logo.src = savedLogo;
document.getElementById('bgSelect')?.addEventListener('change', e => {
  if (!bg) return;
  bg.style.backgroundImage = e.target.value ? `url(${e.target.value})` : '';
  localStorage.setItem('panel_bg', e.target.value);
});
document.getElementById('logoUpload')?.addEventListener('change', e => {
  const file = e.target.files[0];
  if (!file || !logo) return;
  const reader = new FileReader();
  reader.onload = () => {
    logo.src = reader.result;
    localStorage.setItem('panel_logo', reader.result);
  };
  reader.readAsDataURL(file);
});
