<?php
require_once __DIR__ . '/common.php';
require_login();

$data = read_panel_data();
$toast = ''; $err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  try {
    $active = (int)($_POST['active_dns'] ?? 1);
    $dns = [];
    for ($i=1;$i<=5;$i++) {
      $name = trim((string)($_POST['name'][$i] ?? ('DNS '.$i)));
      $url  = trim((string)($_POST['url'][$i] ?? ''));
      $enabled = !empty($_POST['enabled'][$i]);
      if ($url !== '' && !preg_match('~^https?://~i', $url)) $url = 'http://' . $url;
      $dns[] = ['id'=>$i,'name'=>$name ?: ('DNS '.$i),'url'=>$url,'enabled'=>$enabled];
    }
    $data['active_dns'] = max(1, min(5, $active));
    $data['dns'] = $dns;

    if (!empty($_POST['new_user']) && !empty($_POST['new_pass'])) {
        $data['auth']['user'] = trim((string)$_POST['new_user']);
        $data['auth']['pass'] = trim((string)$_POST['new_pass']);
    }

    write_panel_data($data);
    $toast = 'Saved.';
    $data = read_panel_data();
  } catch (Throwable $e) {
    $err = 'Error: ' . $e->getMessage();
  }
}

$endpoint = base_url() . '/panel.json';
?><!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>MultiDNS Panel</title>
<script src="https://unpkg.com/lucide@latest"></script>
<style>
  :root{--bg:#070A12;--bg2:#0B1022;--card:rgba(255,255,255,.05);--stroke:rgba(255,255,255,.08);--text:#EAF0FF;--muted:#8A96B3;--accent:#6ee7b7;--accent2:#60a5fa;--good:#4ade80;--bad:#fb7185;}
  *{box-sizing:border-box}
  body{margin:0;font-family:Inter,system-ui,sans-serif;background:radial-gradient(1000px 500px at 10% -10%, rgba(96,165,250,0.2), transparent 70%),linear-gradient(180deg,var(--bg),var(--bg2));color:var(--text);min-height:100vh;padding:12px}
  
  .top{display:flex;align-items:center;justify-content:space-between;margin:0 auto 10px auto;max-width:1000px}
  .brand{display:flex;gap:8px;align-items:center}
  .logo{width:30px;height:30px;border-radius:8px;background:linear-gradient(135deg,var(--accent),var(--accent2));display:flex;align-items:center;justify-content:center;color:#0b1022}
  .logo svg{width:18px;height:18px}
  h1{font-size:14px;margin:0} .sub{font-size:10px;color:var(--muted)}
  
  .wrap{max-width:1000px;margin:0 auto;display:grid;gap:10px}
  .card{background:var(--card);border:1px solid var(--stroke);border-radius:12px;backdrop-filter: blur(10px);padding:12px;box-shadow:0 10px 30px rgba(0,0,0,.2)}
  .card-header{display:flex;justify-content:space-between;align-items:center;margin-bottom:8px}
  h2{font-size:11px;margin:0;text-transform:uppercase;letter-spacing:1px;color:var(--muted)}
  
  .btn{display:inline-flex;align-items:center;gap:4px;padding:5px 10px;border-radius:8px;border:1px solid rgba(255,255,255,.1);background:rgba(255,255,255,.05);color:var(--text);text-decoration:none;cursor:pointer;font-size:11px;transition:0.2s}
  .btn:hover{background:rgba(255,255,255,.12)}
  .save-top{background:linear-gradient(90deg,var(--accent),var(--accent2));border:0;color:#0b1022;font-weight:700;padding:6px 16px}
  
  .endpoint-row{display:flex;align-items:center;gap:6px;background:rgba(0,0,0,0.3);padding:4px 8px;border-radius:8px;border:1px solid var(--stroke)}
  code{font-family:monospace;font-size:11px;color:var(--accent2);flex:1;overflow:hidden;text-overflow:ellipsis}
  
  .rows{display:grid;gap:6px}
  .rowcard{background:rgba(0,0,0,0.2);border:1px solid rgba(255,255,255,0.05);border-radius:10px;padding:6px 10px;display:grid;grid-template-columns:1.2fr 2fr 0.6fr 0.8fr;gap:10px;align-items:center}
  @media (max-width:768px){.rowcard{grid-template-columns:1fr 1fr; gap:8px}}
  
  .field label{display:block;font-size:9px;text-transform:uppercase;color:var(--muted);margin-bottom:2px}
  .field input{width:100%;padding:6px 8px;border-radius:6px;border:1px solid rgba(255,255,255,.08);background:rgba(0,0,0,0.2);color:var(--text);outline:none;font-size:12px}
  
  .switch{display:flex;align-items:center;gap:6px}
  .switch input{width:30px;height:16px;appearance:none;background:rgba(255,255,255,.1);border-radius:10px;position:relative;cursor:pointer;outline:none}
  .switch input:checked{background:rgba(110,231,183,.2)}
  .switch input::after{content:"";position:absolute;top:2px;left:2px;width:12px;height:12px;border-radius:50%;background:#fff;transition:0.2s}
  .switch input:checked::after{left:16px;background:var(--good)}
  
  .badge{display:flex;align-items:center;gap:4px;padding:3px 8px;border-radius:6px;border:1px solid rgba(255,255,255,.1);font-size:10px;cursor:pointer}
  .badge input{margin:0; accent-color:var(--accent)}
  
  .toast{position:fixed;right:15px;bottom:15px;background:rgba(0,0,0,0.9);border:1px solid var(--accent);color:var(--text);padding:8px 16px;border-radius:8px;font-size:12px;z-index:999}
</style>
</head>
<body>
  <form method="post">
    <div class="top">
      <div class="brand">
        <div class="logo"><i data-lucide="globe"></i></div>
        <div><h1>MultiDNS</h1><div class="sub">V1.1 • Wave UI</div></div>
      </div>
      <div class="actions">
        <a class="btn" href="panel.json" target="_blank">JSON</a>
        <a class="btn" href="login.php?logout=1" style="color:var(--bad)">Logout</a>
      </div>
    </div>

    <div class="wrap">
      <div class="card">
        <div class="card-header">
          <h2>Endpoint URL</h2>
          <button class="btn save-top" type="submit"><i data-lucide="save" style="width:12px"></i> Save All</button>
        </div>
        <div class="endpoint-row">
            <code id="endpointUrl"><?php echo h($endpoint); ?></code>
            <button type="button" class="btn" onclick="copyUrl()" style="padding:3px 6px"><i data-lucide="copy" style="width:12px"></i></button>
        </div>
      </div>

      <div class="card">
        <h2>DNS Slots</h2>
        <div class="rows" style="margin-top:8px">
          <?php foreach($data['dns'] as $row): $i=(int)$row['id']; ?>
            <div class="rowcard">
              <div class="field"><label>Label</label><input name="name[<?php echo $i; ?>]" value="<?php echo h($row['name']); ?>"></div>
              <div class="field"><label>URL</label><input name="url[<?php echo $i; ?>]" value="<?php echo h($row['url']); ?>"></div>
              <div class="field"><label>Status</label>
                <div class="switch">
                  <input type="checkbox" name="enabled[<?php echo $i; ?>]" value="1" <?php echo $row['enabled']?'checked':''; ?>>
                  <span style="font-size:9px; font-weight:700; color:<?php echo $row['enabled']?'var(--good)':'var(--muted)'; ?>"><?php echo $row['enabled']?'ON':'OFF'; ?></span>
                </div>
              </div>
              <div class="field"><label>Select</label>
                <label class="badge"><input type="radio" name="active_dns" value="<?php echo $i; ?>" <?php echo ((int)$data['active_dns']===$i)?'checked':''; ?>> <?php echo ((int)$data['active_dns']===$i)?'Active':'Use'; ?></label>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      </div>

      <div class="card">
        <h2>Admin Access</h2>
        <div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px; margin-top:6px">
            <div class="field"><label>User</label><input name="new_user" value="<?php echo h($data['auth']['user'] ?? 'admin'); ?>"></div>
            <div class="field"><label>Pass</label><input name="new_pass" type="text" value="<?php echo h($data['auth']['pass'] ?? 'admin123'); ?>"></div>
        </div>
      </div>
    </div>
  </form>

  <div id="toast" class="toast" style="display:none"></div>

  <script>
    lucide.createIcons();
    function copyUrl() {
        const urlText = document.getElementById('endpointUrl').innerText;
        navigator.clipboard.writeText(urlText).then(() => showToast('📋 Copied!'));
    }
    function showToast(msg) {
        const t = document.getElementById('toast');
        t.innerText = msg; t.style.display = 'block';
        setTimeout(() => { t.style.display = 'none'; }, 2000);
    }
    <?php if($toast): ?>showToast('✅ Saved');<?php endif; ?>
  </script>
</body>
</html>