<?php
require_once __DIR__ . '/common.php';
if (session_status() !== PHP_SESSION_ACTIVE) session_start();

$err = '';
if (isset($_GET['logout'])) {
    $_SESSION = [];
    session_destroy();
    header('Location: login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $u = (string)($_POST['u'] ?? '');
    $p = (string)($_POST['p'] ?? '');
    
    $data = read_panel_data();
    $stored_user = $data['auth']['user'] ?? 'admin';
    $stored_pass = $data['auth']['pass'] ?? 'admin123';

    if (hash_equals($stored_user, $u) && hash_equals($stored_pass, $p)) {
        $_SESSION['panel_ok'] = true;
        header('Location: dns.php');
        exit;
    }
    $err = 'Invalid login.';
}
?><!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Login • MultiDNS Panel</title>
<script src="https://unpkg.com/lucide@latest"></script>
<style>
  :root{--bg:#070A12;--bg2:#0B1022;--card:rgba(255,255,255,.06);--stroke:rgba(255,255,255,.10);--text:#EAF0FF;--muted:#9AA6C3;--accent:#6ee7b7;--accent2:#60a5fa;--accent3:#c084fc;--bad:#fb7185;}
  *{box-sizing:border-box} 
  body{margin:0;font-family:Inter,system-ui,sans-serif;background:radial-gradient(1200px 600px at 10% -10%, rgba(96,165,250,.35), transparent 60%),linear-gradient(180deg,var(--bg),var(--bg2));color:var(--text);min-height:100vh;display:flex;align-items:center;justify-content:center;padding:24px}
  .card{width:min(380px,100%);background:var(--card);border:1px solid var(--stroke);border-radius:14px;backdrop-filter: blur(14px);padding:24px;box-shadow:0 15px 40px rgba(0,0,0,.3); text-align: center;}
  .brand{display:flex;flex-direction:column;align-items:center;gap:12px;margin-bottom:24px}
  .logo{width:42px;height:42px;border-radius:12px;background:linear-gradient(135deg,var(--accent),var(--accent2),var(--accent3));display:flex;align-items:center;justify-content:center;color:#0b1022}
  h1{font-size:18px;margin:0}
  .sub{font-size:12px;color:var(--muted);margin-top:4px}
  .field{text-align: left; margin-bottom: 14px;}
  label{display:block;font-size:10px;text-transform:uppercase;color:var(--muted);margin:0 0 6px 2px}
  input{width:100%;padding:10px 12px;border-radius:10px;border:1px solid rgba(255,255,255,.1);background:rgba(0,0,0,.2);color:var(--text);outline:none;font-size:14px}
  button{width:100%;margin-top:10px;padding:10px;border-radius:10px;border:0;background:linear-gradient(90deg,var(--accent),var(--accent2));color:#0b1022;font-weight:800;cursor:pointer}
  .err{margin-top:14px;color:var(--bad);font-size:12px;padding:8px;background:rgba(251,113,133,0.1);border-radius:8px;border:1px solid rgba(251,113,133,0.2)}
</style>
</head>
<body>
  <form class="card" method="post">
    <div class="brand">
      <div class="logo"><i data-lucide="globe"></i></div>
      <div><h1>MultiDNS Panel</h1><div class="sub">Secure Access</div></div>
    </div>
    <div class="field"><label>Username</label><input name="u" required></div>
    <div class="field"><label>Password</label><input name="p" type="password" required></div>
    <button type="submit">Log In</button>
    <?php if($err): ?><div class="err"><?php echo h($err); ?></div><?php endif; ?>
  </form>
  <script>lucide.createIcons();</script>
</body>
</html>