<?php
// mdns redirect proxy — FIXED PATH HANDLING

$panelFile = __DIR__ . '/../panel.json';

$data = json_decode(@file_get_contents($panelFile), true);
if (!$data || empty($data['dns'])) {
    http_response_code(503);
    exit('NO DNS');
}

$active = $data['active_dns'] ?? 0;
$target = '';

foreach ($data['dns'] as $dns) {
    if ($dns['id'] == $active && !empty($dns['enabled'])) {
        $target = rtrim($dns['url'], '/');
        break;
    }
}

if (!$target) {
    http_response_code(503);
    exit('DNS DISABLED');
}

// Extract ONLY the API path (critical fix)
$uri = $_SERVER['REQUEST_URI'];

// remove everything up to /mdns
$apiPath = preg_replace('#^/wave12/panel/mdns#', '', $uri);

// safety
if ($apiPath === '') {
    $apiPath = '/';
}

// Redirect to REAL DNS + correct API path
header("Location: {$target}{$apiPath}", true, 307);
exit;
