<?php
require_once __DIR__ . '/common.php';
require_login();

$data = read_panel_data();
$id = max(1, min(5, (int)($_GET['id'] ?? 1)));
$dns = null;
foreach ($data['dns'] as $r) { if ((int)$r['id'] === $id) { $dns = $r; break; } }
if (!$dns) { http_response_code(404); echo 'Not found'; exit; }

$url = trim((string)$dns['url']);
if ($url === '') { echo 'Empty URL'; exit; }

// lightweight reachability check
$start = microtime(true);
$ok = false;
$code = 0;
$err = '';

$ch = curl_init();
curl_setopt_array($ch, [
  CURLOPT_URL => $url,
  CURLOPT_NOBODY => true,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_TIMEOUT => 6,
  CURLOPT_CONNECTTIMEOUT => 4,
  CURLOPT_SSL_VERIFYPEER => false,
  CURLOPT_SSL_VERIFYHOST => 0,
  CURLOPT_USERAGENT => 'MultiDNSPanel/1.0'
]);
$res = curl_exec($ch);
if ($res === false) {
  $err = curl_error($ch);
} else {
  $code = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
  $ok = ($code >= 200 && $code < 500); // treat 4xx as reachable
}
curl_close($ch);
$ms = (int)round((microtime(true)-$start)*1000);

header('Content-Type: application/json; charset=utf-8');
echo json_encode([
  'id' => $id,
  'name' => $dns['name'],
  'url' => $url,
  'enabled' => (bool)$dns['enabled'],
  'reachable' => $ok,
  'http_code' => $code,
  'latency_ms' => $ms,
  'error' => $err,
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
